<?php
class AgendaClass{
	public $ageID;
	public $ageFecha;
	public $ageHora;
	public $ageMin;
	public $ageTitulo;
	public $ageLugar;
	public $ageActividades;
	public $funcionarioID;
	
	function listarAgendaTodos($fechaIni,$fechaFin,$pagina,$cant)
	{
		$vConsulta="SELECT 	age_id, age_fecha, age_hora, 
		age_min, age_actividades, funcionario_id
		FROM agenda WHERE age_fecha BETWEEN '".$fechaIni."' AND '".$fechaFin."' 
		ORDER BY age_fecha DESC, age_hora DESC ,  age_min DESC ";
		$oConexion= new ConexionClass();
		$rscargo=$oConexion->Ejecutar_Consulta($vConsulta);
		$numeroRegistros=$rscargo->num_rows;
		$tamPag=$cant; 
    	//pagina actual si no esta definida y limites 
    	if(!isset($pagina))
		{	
			$pagina=1; 
       		$inicio=1; 
       		$final=$tamPag;
		}
		else
		{ 
       		$pagina = $pagina; 
    	} 
    	//calculo del limite inferior 
    	$limitInf=($pagina-1)*$tamPag; 

    	//calculo del numero de paginas 
    	$numPags=ceil($numeroRegistros/$tamPag); 
    	if(!isset($pagina)){ 
       		$pagina=1; 
       		$inicio=1; 
       		$final=$tamPag; 
    	}else{ 
       		$seccionActual=intval(($pagina-1)/$tamPag); 
       		$inicio=($seccionActual*$tamPag)+1; 
       		if($pagina<$numPags) 
       		{ 
          		$final=$inicio+$tamPag-1; 
       		}
			else
			{ 
          		$final=$numPags; 
       		} 
       		if ($final>$numPags)
			{ 
          		$final=$numPags; 
       		} 
		}
		$vConsulta.=" limit ".$limitInf.",".$tamPag;
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);
		return $rs;
	}
	
	function contarAgendas($fechaIni,$fechaFin)
	{
		$vConsulta="SELECT 	age_id, age_fecha, age_hora, 
			age_min, age_actividades,funcionario_id
			FROM agenda WHERE age_fecha BETWEEN '".$fechaIni."' AND '".$fechaFin."' 
			ORDER BY age_fecha DESC, age_hora DESC ,  age_min DESC ";
		$oConexion= new ConexionClass();
		$rsarc=$oConexion->Ejecutar_Consulta($vConsulta);
		$nr=$rsarc->num_rows;
		return $nr;
	}
	
	function insertarAgenda()
	{
		$oConexion= new ConexionClass(); 
		$strSQL="INSERT INTO agenda (age_fecha, age_hora, age_min, age_actividades, funcionario_id) VALUES(
		'".$oConexion->Escapar_Caracteres($this->ageFecha)."', 
		'".$oConexion->Escapar_Caracteres($this->ageHora)."',  
		'".$oConexion->Escapar_Caracteres($this->ageMin)."', 
		'".$oConexion->Escapar_Caracteres($this->ageActividades)."',
		".intval($this->funcionarioID).")";
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function getAgenda($agendaID)
	{
		$vConsulta="SELECT 	age_id, age_fecha, age_hora, 
			age_min, age_actividades, funcionario_id
			FROM agenda WHERE age_id=".intval($agendaID);
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;	
	}
			
	function actualizarAgenda()
	{
		$oConexion= new ConexionClass();
		$strSQL="UPDATE agenda SET age_fecha = '".$oConexion->Escapar_Caracteres($this->ageFecha)."', 
		age_hora = '".$oConexion->Escapar_Caracteres($this->ageHora)."', 
		age_min = '".$oConexion->Escapar_Caracteres($this->ageMin)."', 
		age_actividades = '".$oConexion->Escapar_Caracteres($this->ageActividades)."', 
		funcionario_id = ".intval($this->alcaldeActivo)." WHERE age_id=".intval($this->ageID);
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function eliminarAgenda($agendaID)	
	{
		$strSQL="DELETE FROM agenda WHERE age_id=".intval($agendaID);
		$oConexion= new ConexionClass();
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function getListFechaAgenda($anio,$mes)
	{
		$vConsulta="SELECT DISTINCT(age_fecha)	FROM agenda 
					WHERE YEAR(age_fecha)='".$anio."' AND MONTH(age_fecha)='".$mes."' 
					ORDER BY age_fecha DESC ";
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		return $rs;	
	}
	
	function getListHoraAgenda($fecha)
	{
		$vConsulta="SELECT age_hora, age_min, age_actividades FROM agenda 
					WHERE age_fecha='".$fecha."' ORDER BY age_hora, age_min ";
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		return $rs;	
	}
	
	function getAgendaPosc($posicion)
	{
		$vConsulta="SELECT age_id, age_fecha, age_hora, 
			age_min, age_titulo, age_lugar, age_actividades,funcionario_id,
			DATE_FORMAT(age_fecha, '%Y') AS anio, DATE_FORMAT(age_fecha, '%m') AS mes
			FROM agenda ORDER BY age_fecha DESC LIMIT ".$posicion.", 1";
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;	
	}
}
?>