<?php
class AlcaldeClass{
	public $alcaldeID;
	public $alcaldeFoto;
	public $alcaldeNombre;
	public $alcaldeProfesion;	
	public $alcaldeMensaje;
	public $alcaldeActivo;
	
	function listarAlcaldeTodos($nombreAlcalde,$pagina,$cant)
	{
		$vConsulta="SELECT 	alcalde_id, alcalde_foto, alcalde_nombre, alcalde_profesion, 	
		alcalde_mensaje, alcalde_activo FROM alcalde WHERE alcalde_nombre LIKE '%".$nombreAlcalde."%' 
		ORDER 	BY alcalde_id DESC ";		
		$oConexion= new ConexionClass();
		$rscargo=$oConexion->Ejecutar_Consulta($vConsulta);
		$numeroRegistros=$rscargo->num_rows;
		$tamPag=$cant; 
    	//pagina actual si no esta definida y limites 
    	if(!isset($pagina))
		{	
			$pagina=1; 
       		$inicio=1; 
       		$final=$tamPag;
		}
		else
		{ 
       		$pagina = $pagina; 
    	} 
    	//calculo del limite inferior 
    	$limitInf=($pagina-1)*$tamPag; 

    	//calculo del numero de paginas 
    	$numPags=ceil($numeroRegistros/$tamPag); 
    	if(!isset($pagina)){ 
       		$pagina=1; 
       		$inicio=1; 
       		$final=$tamPag; 
    	}else{ 
       		$seccionActual=intval(($pagina-1)/$tamPag); 
       		$inicio=($seccionActual*$tamPag)+1; 
       		if($pagina<$numPags) 
       		{ 
          		$final=$inicio+$tamPag-1; 
       		}
			else
			{ 
          		$final=$numPags; 
       		} 
       		if ($final>$numPags)
			{ 
          		$final=$numPags; 
       		} 
		}
		$vConsulta.=" limit ".$limitInf.",".$tamPag;
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);
		return $rs;
	}
	
	function contarAlcaldes($nombreAlcalde)
	{
		$vConsulta="SELECT alcalde_id, alcalde_foto, alcalde_nombre, alcalde_profesion, 	
		alcalde_mensaje, alcalde_activo FROM alcalde WHERE alcalde_nombre 
		LIKE '%".$nombreAlcalde."%' ORDER BY alcalde_nombre";
		$oConexion= new ConexionClass();
		$rsarc=$oConexion->Ejecutar_Consulta($vConsulta);
		$nr=$rsarc->num_rows;
		return $nr;
	}
	
	function getAlcaldeCountActivoNew()
	{
		$vConsulta="SELECT COUNT(alcalde_id) AS cant FROM alcalde WHERE alcalde_activo='1' ";
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;	
	}
	
	function insertarAlcaldes()
	{
		$oConexion= new ConexionClass(); 
		$strSQL="INSERT INTO alcalde (alcalde_foto, alcalde_nombre, alcalde_profesion, alcalde_mensaje, alcalde_activo) VALUES('', '".$oConexion->Escapar_Caracteres($this->alcaldeNombre)."', '".$oConexion->Escapar_Caracteres($this->alcaldeProfesion)."',  '".$this->alcaldeMensaje."', '".$oConexion->Escapar_Caracteres($this->alcaldeActivo)."')";
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function getAlcaldeID()
	{
		$vConsulta="SELECT alcalde_id FROM alcalde ORDER BY alcalde_id DESC LIMIT 1";
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;				
	}
	
	function actualizarFotoPortada()
	{
		$oConexion= new ConexionClass();
		$strSQL="UPDATE alcalde SET alcalde_foto = '".$oConexion->Escapar_Caracteres($this->alcaldeFoto)."' 
		WHERE alcalde_id=".intval($this->alcaldeID);
		return $oConexion->Ejecutar_SQL($strSQL);
	}	
	
	function getAlcalde($alcaldeID)
	{
		$vConsulta="SELECT alcalde_id, alcalde_foto, alcalde_nombre, alcalde_profesion, 	
		alcalde_mensaje, alcalde_activo FROM alcalde WHERE alcalde_id=".intval($alcaldeID);
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;	
	}	
	
	function getAlcaldeCountActivoUpdate($alcaldeID)
	{
		$vConsulta="SELECT COUNT(alcalde_id) AS cant FROM alcalde WHERE alcalde_activo='1' 
		AND alcalde_id!=".intval($alcaldeID);
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;	
	}
	
	function actualizarAlcalde()
	{
		$oConexion= new ConexionClass();
		$strSQL="UPDATE alcalde SET alcalde_nombre = '".$oConexion->Escapar_Caracteres($this->alcaldeNombre)."', alcalde_profesion = '".$oConexion->Escapar_Caracteres($this->alcaldeProfesion)."', alcalde_mensaje = '".$this->alcaldeMensaje."', alcalde_activo = '".$oConexion->Escapar_Caracteres($this->alcaldeActivo)."' WHERE alcalde_id=".intval($this->alcaldeID);
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function eliminarAlcalde($alcaldeID)	
	{
		$strSQL="DELETE FROM alcalde WHERE alcalde_id=".intval($alcaldeID);
		$oConexion= new ConexionClass();
		return $oConexion->Ejecutar_SQL($strSQL);
	}
			
	function getAlcaldeActual()
	{
		$vConsulta="SELECT alcalde_id, alcalde_foto, alcalde_nombre, alcalde_profesion, 
		alcalde_mensaje, alcalde_activo FROM alcalde WHERE alcalde_activo=1 LIMIT 1";
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;			
	}
	
}
?>