<?php
class AnioClass{
	public $anioID;
	public $anioNombre;
	public $anioDenominacion;
	
	function listarAnioTodos($nombreAnio,$pagina,$cant)
	{
		$vConsulta="SELECT anio_id, nombre, denominacion 
		FROM anio WHERE nombre LIKE '%".$nombreAnio."%' ORDER BY nombre DESC ";		
		$oConexion= new ConexionClass();
		$rscargo=$oConexion->Ejecutar_Consulta($vConsulta);
		$numeroRegistros=$rscargo->num_rows;
		$tamPag=$cant; 
    	//pagina actual si no esta definida y limites 
    	if(!isset($pagina))
		{	
			$pagina=1; 
       		$inicio=1; 
       		$final=$tamPag;
		}
		else
		{ 
       		$pagina = $pagina; 
    	} 
    	//calculo del limite inferior 
    	$limitInf=($pagina-1)*$tamPag; 

    	//calculo del numero de paginas 
    	$numPags=ceil($numeroRegistros/$tamPag); 
    	if(!isset($pagina)){ 
       		$pagina=1; 
       		$inicio=1; 
       		$final=$tamPag; 
    	}else{ 
       		$seccionActual=intval(($pagina-1)/$tamPag); 
       		$inicio=($seccionActual*$tamPag)+1; 
       		if($pagina<$numPags) 
       		{ 
          		$final=$inicio+$tamPag-1; 
       		}
			else
			{ 
          		$final=$numPags; 
       		} 
       		if ($final>$numPags)
			{ 
          		$final=$numPags; 
       		} 
		}
		$vConsulta.=" limit ".$limitInf.",".$tamPag;
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);
		return $rs;
	}
	
	function contarAnios($nombreAnio)
	{
		$vConsulta="SELECT anio_id, nombre, denominacion 
		FROM anio WHERE nombre LIKE '%".$nombreAnio."%' ORDER BY nombre DESC ";		
		$oConexion= new ConexionClass();
		$rsarc=$oConexion->Ejecutar_Consulta($vConsulta);
		$nr=$rsarc->num_rows;
		return $nr;
	}
	
	function getAnioCountNew($nombre)
	{
		$vConsulta="SELECT COUNT(anio_id) AS cant FROM anio 
		WHERE nombre='".$nombre."' ";
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;	
	}
	
	function insertarAnio()
	{
		$oConexion= new ConexionClass(); 
		$strSQL="INSERT INTO anio(nombre, denominacion) VALUES('".$oConexion->Escapar_Caracteres($this->anioNombre)."', '".$oConexion->Escapar_Caracteres($this->anioDenominacion)."')";
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function getAnioCountUpdate($nombre, $anioID)
	{
		$vConsulta="SELECT COUNT(anio_id) AS cant FROM anio 
		WHERE nombre='".$nombre."' AND anio_id != '".$anioID."' ";
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;	
	}
	
	function actualizarAnio()
	{
		$oConexion= new ConexionClass();
		$strSQL="UPDATE anio SET nombre='".$oConexion->Escapar_Caracteres($this->anioNombre)."', 
	denominacion='".$oConexion->Escapar_Caracteres($this->anioDenominacion)."' WHERE anio_id=".intval($this->anioID);
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function getAnioCountObra($anioID)
	{
		$vConsulta="SELECT COUNT(anio_id) AS cant FROM obra 
		WHERE anio_id = '".$anioID."' ";
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;	
	}
	
	function getAnioCountConvocatoria($anioID)
	{
		$vConsulta="SELECT COUNT(anio_id) AS cant FROM convocatoria 
		WHERE anio_id = '".$anioID."' ";
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;	
	}
	
	function getAnioCountDetalleMenu($anioID)
	{
		$vConsulta="SELECT COUNT(anio_id) AS cant FROM detalle_menu 
		WHERE anio_id = '".$anioID."' ";
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;	
	}
	
	function eliminarAnio()	
	{
		$strSQL="DELETE FROM anio WHERE anio_id=".intval($this->anioID);
		$oConexion= new ConexionClass();
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function getAnio($anioID)
	{
		$vConsulta="SELECT anio_id, nombre, denominacion FROM anio WHERE anio_id=".intval($anioID);
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;				
	}	
	
	function getAnioActual()
	{
		$vConsulta="SELECT anio_id, nombre, denominacion FROM anio WHERE nombre=(SELECT YEAR(CURDATE()))";
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;				
	}	
	
	function getListAnios()
	{
		$vConsulta="SELECT anio_id, nombre, denominacion FROM anio ORDER BY nombre DESC ";
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);	
			return $rs;	
	}	
}
?>