<?php
class ArchivosConvocatoriaClass{
	public $ArcConID;
	public $ArcConDescripcion;
	public $ArcConArchivo;
	public $DetEstConID;
	
	function listarArchivosConvocatoriaTodos($decID,$pagina)
	{
		$vConsulta="SELECT 	arc_con_id, arc_con_descripcion, arc_con_archivo, det_est_con_id FROM archivos_convocatoria WHERE det_est_con_id = ".intval($decID)." ORDER BY arc_con_id";
		
		$oConexion= new ConexionClass();
		$rscargo=$oConexion->Ejecutar_Consulta($vConsulta);
		$numeroRegistros=$rscargo->num_rows;
		$tamPag=200; 
    	//pagina actual si no esta definida y limites 
    	if(!isset($pagina))
		{	
			$pagina=1; 
       		$inicio=1; 
       		$final=$tamPag;
		}
		else
		{ 
       		$pagina = $pagina; 
    	} 
    	//calculo del limite inferior 
    	$limitInf=($pagina-1)*$tamPag; 

    	//calculo del numero de paginas 
    	$numPags=ceil($numeroRegistros/$tamPag); 
    	if(!isset($pagina)){ 
       		$pagina=1; 
       		$inicio=1; 
       		$final=$tamPag; 
    	}else{ 
       		$seccionActual=intval(($pagina-1)/$tamPag); 
       		$inicio=($seccionActual*$tamPag)+1; 
       		if($pagina<$numPags) 
       		{ 
          		$final=$inicio+$tamPag-1; 
       		}
			else
			{ 
          		$final=$numPags; 
       		} 
       		if ($final>$numPags)
			{ 
          		$final=$numPags; 
       		} 
		}
		$vConsulta.=" limit ".$limitInf.",".$tamPag;
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);
		return $rs;
	}
	
	function contarArchivosConvocatoria($ArcConDescripcion)
	{
		if(trim($ArcConDescripcion)!="")
		{
			$vConsulta="SELECT 	arc_con_id, arc_con_descripcion, arc_con_archivo, det_est_con_id FROM 	archivos_convocatoria WHERE arc_con_descripcion LIKE '%".$ArcConDescripcion."%' ORDER BY arc_con_descripcion";
		}
		else
		{
			$vConsulta="SELECT 	arc_con_id, arc_con_descripcion, arc_con_archivo, det_est_con_id FROM 	archivos_convocatoria ORDER BY arc_con_descripcion";
		}
		$oConexion= new ConexionClass();
		$rsarc=$oConexion->Ejecutar_Consulta($vConsulta);
		$nr=$rsarc->num_rows;
		return $nr;
	}
	
	function insertarArchivosConvocatoria()
	{
		$oConexion= new ConexionClass(); 
		$strSQL="INSERT INTO archivos_convocatoria (arc_con_descripcion, arc_con_archivo, det_est_con_id)	VALUES ('".$oConexion->Escapar_Caracteres($this->ArcConDescripcion)."', '', ".intval($this->DetEstConID).")";
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function getArchivoConvocatoriaID()
	{
		$vConsulta="SELECT arc_con_id FROM archivos_convocatoria ORDER BY arc_con_id DESC LIMIT 1";
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;				
	}
	
	function actualizarArchivo()
	{
		$oConexion= new ConexionClass();
		$strSQL="UPDATE archivos_convocatoria SET arc_con_archivo = '".$oConexion->Escapar_Caracteres($this->ArcConArchivo)."' WHERE arc_con_id=".intval($this->ArcConID);
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function getArchivosConvocatoria($ArcConID)
	{
		$vConsulta="SELECT 	arc_con_id, arc_con_descripcion, arc_con_archivo, det_est_con_id FROM 	archivos_convocatoria WHERE arc_con_id=".intval($ArcConID);
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;	
			
	}	
	
	function actualizarArchivosConvocatoria()
	{
		$oConexion= new ConexionClass();
		$strSQL="UPDATE archivos_convocatoria SET arc_con_descripcion = '".$oConexion->Escapar_Caracteres($this->ArcConDescripcion)."', arc_con_archivo = '".$oConexion->Escapar_Caracteres($this->ArcConArchivo)."', det_est_con_id = ".intval($this->DetEstConID)." WHERE arc_con_id = ".intval($this->ArcConID);	
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function eliminarArchivosConvocatoria($ArcConID)	
	{
		$strSQL="DELETE FROM archivos_convocatoria WHERE arc_con_id=".intval($ArcConID);
		$oConexion= new ConexionClass();
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function listarArchivosConvocatoriaCONVID($convID,$estID)
	{
		if($estID==1):
			$vConsulta="SELECT 	arc_con_id, arc_con_descripcion, arc_con_archivo,
			ac.det_est_con_id 
			FROM archivos_convocatoria ac
			INNER JOIN detalle_estado_convocatoria dc ON 	
			ac.det_est_con_id=dc.det_est_con_id
			WHERE con_id = ".intval($convID)." and dc.est_con_id in (1)
			ORDER BY dc.est_con_id, ac.det_est_con_id, arc_con_id ";		
		elseif($estID==2):
			$vConsulta="SELECT 	arc_con_id, arc_con_descripcion, arc_con_archivo,
			ac.det_est_con_id 
			FROM archivos_convocatoria ac
			INNER JOIN detalle_estado_convocatoria dc ON 	
			ac.det_est_con_id=dc.det_est_con_id
			WHERE con_id = ".intval($convID)." and dc.est_con_id in (1,2) 
			ORDER BY dc.est_con_id, ac.det_est_con_id, arc_con_id ";
		elseif($estID==3):
			$vConsulta="SELECT 	arc_con_id, arc_con_descripcion, arc_con_archivo,
			ac.det_est_con_id 
			FROM archivos_convocatoria ac
			INNER JOIN detalle_estado_convocatoria dc ON 	
			ac.det_est_con_id=dc.det_est_con_id
			WHERE con_id = ".intval($convID)." 
			ORDER BY dc.est_con_id, ac.det_est_con_id, arc_con_id ";
		endif;
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);
		return $rs;
	}
}
?>