<?php
class CategoriaConvocatoriaClass{
	public $CategoriaConvocatoriaID;
	public $CategoriaConvocatoriaNombre;
	public $CategoriaConvocatoriaAbreviatura;
	public $CategoriaConvocatoriaActivo;
	
	function listarCategoriaConvocatoriaTodos($nombreCategoriaConvocatoria,$pagina)
	{
		if(trim($nombreCategoriaConvocatoria)!="")
		{
			$vConsulta="SELECT cc_id, cc_nombre, cc_abreviatura, cc_activo FROM categoria_convocatoria WHERE cc_nombre LIKE '%".$nombreCategoriaConvocatoria."%' ORDER BY cc_nombre";
		}
		else
		{
			$vConsulta="SELECT cc_id, cc_nombre, cc_abreviatura, cc_activo FROM categoria_convocatoria ORDER BY cc_nombre";
		}
		$oConexion= new ConexionClass();
		$rscargo=$oConexion->Ejecutar_Consulta($vConsulta);
		$numeroRegistros=$rscargo->num_rows;
		$tamPag=20; 
    	//pagina actual si no esta definida y limites 
    	if(!isset($pagina))
		{	
			$pagina=1; 
       		$inicio=1; 
       		$final=$tamPag;
		}
		else
		{ 
       		$pagina = $pagina; 
    	} 
    	//calculo del limite inferior 
    	$limitInf=($pagina-1)*$tamPag; 

    	//calculo del numero de paginas 
    	$numPags=ceil($numeroRegistros/$tamPag); 
    	if(!isset($pagina)){ 
       		$pagina=1; 
       		$inicio=1; 
       		$final=$tamPag; 
    	}else{ 
       		$seccionActual=intval(($pagina-1)/$tamPag); 
       		$inicio=($seccionActual*$tamPag)+1; 
       		if($pagina<$numPags) 
       		{ 
          		$final=$inicio+$tamPag-1; 
       		}
			else
			{ 
          		$final=$numPags; 
       		} 
       		if ($final>$numPags)
			{ 
          		$final=$numPags; 
       		} 
		}
		$vConsulta.=" limit ".$limitInf.",".$tamPag;
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);
		return $rs;
	}
	
	function contarCategoriaConvocatoria($nombreCategoriaConvocatoria)
	{
		if(trim($nombreCategoriaConvocatoria)!="")
		{
			$vConsulta="SELECT cc_id, cc_nombre, cc_abreviatura, cc_activo FROM categoria_convocatoria WHERE cc_nombre LIKE '%".$nombreCategoriaConvocatoria."%' ORDER BY cc_nombre";
		}
		else
		{
			$vConsulta="SELECT cc_id, cc_nombre, cc_abreviatura, cc_activo FROM categoria_convocatoria ORDER BY cc_nombre";
		}
		$oConexion= new ConexionClass();
		$rsarc=$oConexion->Ejecutar_Consulta($vConsulta);
		$nr=$rsarc->num_rows;
		return $nr;
	}
	
	function insertarCategoriaConvocatoria()
	{
		$oConexion= new ConexionClass(); 
		$strSQL="INSERT INTO categoria_convocatoria (cc_nombre, cc_abreviatura, cc_activo) VALUES	('".$oConexion->Escapar_Caracteres($this->CategoriaConvocatoriaNombre)."', '".$oConexion->Escapar_Caracteres($this->CategoriaConvocatoriaAbreviatura)."', '".$oConexion->Escapar_Caracteres($this->CategoriaConvocatoriaActivo)."')";
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function actualizarCategoriaConvocatoria()
	{
		$oConexion= new ConexionClass();
		$strSQL="UPDATE categoria_convocatoria SET	cc_nombre = '".$oConexion->Escapar_Caracteres($this->CategoriaConvocatoriaNombre)."', cc_abreviatura = '".$oConexion->Escapar_Caracteres($this->CategoriaConvocatoriaAbreviatura)."', cc_activo = '".$oConexion->Escapar_Caracteres($this->CategoriaConvocatoriaActivo)."' WHERE cc_id = ".intval($this->CategoriaConvocatoriaID);
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function eliminarCategoriaConvocatoria($CategoriaConvocatoriaID)	
	{
		$strSQL="DELETE FROM categoria_convocatoria WHERE cc_id=".intval($CategoriaConvocatoriaID);
		$oConexion= new ConexionClass();
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function getCategoriaConvocatoria($CategoriaConvocatoriaID)
	{
		$vConsulta="SELECT cc_id, cc_nombre, cc_abreviatura, cc_activo, concat(cc_abreviatura,' - ',cc_nombre) FROM categoria_convocatoria WHERE cc_id=".intval($CategoriaConvocatoriaID);
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;	
			
	}	
		function getCategoriaConvocatoriaActual()
	{
		$vConsulta="SELECT cc_id, cc_nombre, cc_abreviatura, cc_activo FROM categoria_convocatoria WHERE cc_activo=1";
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;	
	}
	
	function getListCategoriaConvocatoriaActivas()
	{
		$vConsulta="SELECT cc_id, cc_nombre, cc_abreviatura, cc_activo, concat(cc_abreviatura,' - ',cc_nombre) 
		FROM categoria_convocatoria 
		WHERE cc_activo=1";
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);				
			return $rs;	
	}
}
?>