<?php
class ConvocatoriaClass{
	public $ConvocatoriaID;
	public $ConvocatoriaFecha;
	public $ConvocatoriaNumero;
	public $ConvocatoriaTitulo;
	public $ConvocatoriaTerminoReferencia;
	public $CategoriaConvocatoriaID;
	public $anioID;
	public $ConvocatoriaCronograma;
	
	function listarConvocatoriaTodos($ConvocatoriaNumero,$pagina,$cant,$catConvID,$anio)
	{
		$vConsulta="SELECT con_id, con_numero, con_titulo, con_termino_ref, convocatoria.cc_id, 
		con_cronograma, cc_abreviatura, nombre 
		FROM convocatoria
		INNER JOIN categoria_convocatoria cc ON convocatoria.cc_id=cc.cc_id
		INNER JOIN anio ON convocatoria.anio_id=anio.anio_id
		WHERE con_numero LIKE '%".$ConvocatoriaNumero."%' 
		AND convocatoria.cc_id LIKE '%".$catConvID."%' 
		AND convocatoria.anio_id LIKE '%".$anio."%'
		ORDER BY con_id DESC ";		
		$oConexion= new ConexionClass();
		$rscargo=$oConexion->Ejecutar_Consulta($vConsulta);
		$numeroRegistros=$rscargo->num_rows;
		$tamPag=$cant; 
    	//pagina actual si no esta definida y limites 
    	if(!isset($pagina))
		{	
			$pagina=1; 
       		$inicio=1; 
       		$final=$tamPag;
		}
		else
		{ 
       		$pagina = $pagina; 
    	} 
    	//calculo del limite inferior 
    	$limitInf=($pagina-1)*$tamPag; 

    	//calculo del numero de paginas 
    	$numPags=ceil($numeroRegistros/$tamPag); 
    	if(!isset($pagina)){ 
       		$pagina=1; 
       		$inicio=1; 
       		$final=$tamPag; 
    	}else{ 
       		$seccionActual=intval(($pagina-1)/$tamPag); 
       		$inicio=($seccionActual*$tamPag)+1; 
       		if($pagina<$numPags) 
       		{ 
          		$final=$inicio+$tamPag-1; 
       		}
			else
			{ 
          		$final=$numPags; 
       		} 
       		if ($final>$numPags)
			{ 
          		$final=$numPags; 
       		} 
		}
		$vConsulta.=" limit ".$limitInf.",".$tamPag;
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);
		return $rs;
	}
	
	function contarConvocatoria($ConvocatoriaNumero,$catConvID,$anio)
	{
		$vConsulta="SELECT con_id, con_numero, con_titulo, con_termino_ref, convocatoria.cc_id, 
		con_cronograma, cc_abreviatura, nombre 
		FROM convocatoria
		INNER JOIN categoria_convocatoria cc ON convocatoria.cc_id=cc.cc_id
		INNER JOIN anio ON convocatoria.anio_id=anio.anio_id
		WHERE con_numero LIKE '%".$ConvocatoriaNumero."%' 
		AND convocatoria.cc_id LIKE '%".$catConvID."%' 
		AND convocatoria.anio_id LIKE '%".$anio."%'
		ORDER BY convocatoria.cc_id, convocatoria.anio_id, con_id DESC ";
		$oConexion= new ConexionClass();
		$rsarc=$oConexion->Ejecutar_Consulta($vConsulta);
		$nr=$rsarc->num_rows;
		return $nr;
	}
	
	function insertarConvocatoria()
	{
		$oConexion= new ConexionClass(); 
		$strSQL="INSERT INTO convocatoria (con_numero,con_titulo,con_termino_ref,cc_id, anio_id,con_cronograma) VALUES ('".$oConexion->Escapar_Caracteres($this->ConvocatoriaNumero)."', '".$this->ConvocatoriaTitulo."', '',".intval($this->CategoriaConvocatoriaID)." , ".intval($this->anioID).",'".$this->ConvocatoriaCronograma."')";
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function getConvocatoriaID()
	{
		$vConsulta="SELECT con_id FROM convocatoria ORDER BY con_id DESC LIMIT 1";
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;				
	}
	
	function actualizarArchivo()
	{
		$oConexion= new ConexionClass();
		$strSQL="UPDATE convocatoria SET con_termino_ref = '".$oConexion->Escapar_Caracteres($this->ConvocatoriaTerminoReferencia)."' WHERE con_id=".intval($this->ConvocatoriaID);
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function getConvocatoria($ConvocatoriaID)
	{
		$vConsulta="SELECT con_id, con_numero, con_titulo, con_termino_ref, cc_id, anio_id, con_cronograma FROM convocatoria WHERE con_id=".intval($ConvocatoriaID);
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;				
	}	
	
	function actualizarConvocatoria()
	{
		$oConexion= new ConexionClass();
		$strSQL="UPDATE convocatoria SET con_numero = '".$oConexion->Escapar_Caracteres($this->ConvocatoriaNumero)."', con_titulo = '".$this->ConvocatoriaTitulo."', cc_id = ".intval($this->CategoriaConvocatoriaID).", anio_id = ".intval($this->anioID).", con_cronograma = '".$this->ConvocatoriaCronograma."' WHERE con_id = ".intval($this->ConvocatoriaID);	
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function getCountConvocatoria($ConvocatoriaID)
	{
		$vConsulta="SELECT count(det_est_con_id) FROM detalle_estado_convocatoria WHERE con_id=".intval($ConvocatoriaID);
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;				
	}	
	
	function eliminarConvocatoria($ConvocatoriaID)	
	{
		$strSQL="DELETE FROM convocatoria WHERE con_id=".intval($ConvocatoriaID);
		$oConexion= new ConexionClass();
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function getlistarConvocatoria($estado,$catConvID,$anio)
	{		
			$vConsulta="SELECT convocatoria.con_id, det_est_con_fecha, con_numero, 
			con_titulo, con_termino_ref, cc_id, det_est_con_id, con_cronograma
			FROM convocatoria 
			INNER JOIN detalle_estado_convocatoria det ON det.con_id=convocatoria.con_id
			INNER JOIN anio ON  convocatoria.anio_id=anio.anio_id
			WHERE  det.det_est_con_activo='1' AND est_con_id=".$estado." 
			AND cc_id=".$catConvID." AND convocatoria.anio_id='".$anio."' ORDER BY det_est_con_fecha DESC ";		
			$oConexion= new ConexionClass();		
			$rs=$oConexion->Ejecutar_Consulta($vConsulta);
			return $rs;
	}
	
	function getlistarEstConvocatoria($est,$conID,$anio)
	{		
			if($est==28){
				$vConsulta="SELECT det_est_con_id, det_est_con_fecha, est_con_descripcion
				FROM detalle_estado_convocatoria det 
				INNER JOIN convocatoria ON det.con_id=convocatoria.con_id
				INNER JOIN estado_convocatoria ON det.est_con_id=estado_convocatoria.est_con_id
				INNER JOIN anio ON  convocatoria.anio_id=anio.anio_id
				WHERE  det.est_con_id=28 AND det.con_id=".$conID." 
				AND nombre='".$anio."' ORDER BY det.est_con_id ";	
			}else if($est==29){
				$vConsulta="SELECT det_est_con_id, det_est_con_fecha, est_con_descripcion
				FROM detalle_estado_convocatoria det 
				INNER JOIN convocatoria ON det.con_id=convocatoria.con_id
				INNER JOIN estado_convocatoria ON det.est_con_id=estado_convocatoria.est_con_id
				INNER JOIN anio ON  convocatoria.anio_id=anio.anio_id
				WHERE det.est_con_id!=30 AND det.con_id=".$conID." 
				AND nombre='".$anio."' ORDER BY det.est_con_id ";	
			}else if($est==30){
				$vConsulta="SELECT det_est_con_id, det_est_con_fecha, est_con_descripcion
				FROM detalle_estado_convocatoria det 
				INNER JOIN convocatoria ON det.con_id=convocatoria.con_id
				INNER JOIN estado_convocatoria ON det.est_con_id=estado_convocatoria.est_con_id
				INNER JOIN anio ON  convocatoria.anio_id=anio.anio_id
				WHERE det.con_id=".$conID." AND nombre='".$anio."' ORDER BY det.est_con_id ";	
			}				
			$oConexion= new ConexionClass();		
			$rs=$oConexion->Ejecutar_Consulta($vConsulta);
			return $rs;
	}
	
}
?>