<?php
class DetEstConvocatoriaClass{
	public $DetEstConvocatoriaID;
	public $EstadoConvocatoriaID;
	public $ConvocatoriaID;
	public $DetEstConvocatoriaFecha;
	public $DetEstConvocatoriaActivo;	
		
	function listarDetEstConvocatoriaTodos($convID, $pagina)
	{
		$vConsulta="SELECT 	det_est_con_id, est_con_descripcion, det_est_con_fecha, det_est_con_activo 
		FROM detalle_estado_convocatoria
		INNER JOIN estado_convocatoria ON
		detalle_estado_convocatoria.est_con_id=estado_convocatoria.est_con_id
		WHERE con_id=".intval($convID)." ORDER BY det_est_con_id ";
		$oConexion= new ConexionClass();
		$rscargo=$oConexion->Ejecutar_Consulta($vConsulta);
		$numeroRegistros=$rscargo->num_rows;
		$tamPag=200; 
    	//pagina actual si no esta definida y limites 
    	if(!isset($pagina))
		{	
			$pagina=1; 
       		$inicio=1; 
       		$final=$tamPag;
		}
		else
		{ 
       		$pagina = $pagina; 
    	} 
    	//calculo del limite inferior 
    	$limitInf=($pagina-1)*$tamPag; 

    	//calculo del numero de paginas 
    	$numPags=ceil($numeroRegistros/$tamPag); 
    	if(!isset($pagina)){ 
       		$pagina=1; 
       		$inicio=1; 
       		$final=$tamPag; 
    	}else{ 
       		$seccionActual=intval(($pagina-1)/$tamPag); 
       		$inicio=($seccionActual*$tamPag)+1; 
       		if($pagina<$numPags) 
       		{ 
          		$final=$inicio+$tamPag-1; 
       		}
			else
			{ 
          		$final=$numPags; 
       		} 
       		if ($final>$numPags)
			{ 
          		$final=$numPags; 
       		} 
		}
		$vConsulta.=" limit ".$limitInf.",".$tamPag;
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);
		return $rs;
	}
	
	function contarDetEstConvocatoria($convID)
	{
		$vConsulta="SELECT 	det_est_con_id, est_con_descripcion, det_est_con_fecha, det_est_con_activo 
		FROM detalle_estado_convocatoria
		INNER JOIN estado_convocatoria ON
		detalle_estado_convocatoria.est_con_id=estado_convocatoria.est_con_id
		WHERE con_id=".intval($convID)." ORDER BY det_est_con_id ";
		$oConexion= new ConexionClass();
		$rsarc=$oConexion->Ejecutar_Consulta($vConsulta);
		$nr=$rsarc->num_rows;
		return $nr;
	}
	
	function getDetEstConvocatoriaActivoNew()	
	{
		$vConsulta="SELECT COUNT(det_est_con_id) FROM detalle_estado_convocatoria WHERE det_est_con_activo='1' AND con_id=".intval($this->ConvocatoriaID);
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;				
	}	
	
	function getDetEstConvocatoriaActivoNew1()	
	{
		$vConsulta="SELECT COUNT(det_est_con_id) FROM detalle_estado_convocatoria WHERE con_id=".intval($this->ConvocatoriaID)." AND est_con_id=".intval($this->EstadoConvocatoriaID);
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;				
	}
		
	function insertarDetEstConvocatoria()
	{
		$oConexion= new ConexionClass(); 
		$strSQL="INSERT INTO detalle_estado_convocatoria (est_con_id, con_id,det_est_con_fecha, det_est_con_activo) VALUES (".intval($this->EstadoConvocatoriaID).", ".intval($this->ConvocatoriaID).", '".$oConexion->Escapar_Caracteres($this->DetEstConvocatoriaFecha)."', ".intval($this->DetEstConvocatoriaActivo).")";
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function actualizarTodosEstados()
	{
		$oConexion= new ConexionClass();
		$strSQL="UPDATE detalle_estado_convocatoria SET det_est_con_activo = 0 WHERE	con_id =  ".intval($this->ConvocatoriaID);	
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function actualizarEstadoActivo()
	{
		$oConexion= new ConexionClass();
		$strSQL="UPDATE detalle_estado_convocatoria SET det_est_con_activo = 1 WHERE	det_est_con_id =  ".intval($this->DetEstConvocatoriaID);	
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function eliminarDetEstConvocatoria($DetEstConvocatoriaID)	
	{
		$strSQL="DELETE FROM detalle_estado_convocatoria WHERE est_con_id=".intval($DetEstConvocatoriaID);
		$oConexion= new ConexionClass();
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function actualizarFecha()
	{
		$oConexion= new ConexionClass();
		$strSQL="UPDATE detalle_estado_convocatoria SET det_est_con_fecha = '".$oConexion->Escapar_Caracteres($this->DetEstConvocatoriaFecha)."' WHERE	det_est_con_id =  ".intval($this->DetEstConvocatoriaID);	
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function getDetEstConvocatoria($DetEstConvocatoriaID)	
	{
		$vConsulta="SELECT det_est_con_id, con_id, est_con_id, det_est_con_fecha, det_est_con_activo FROM detalle_estado_convocatoria WHERE det_est_con_id=".intval($DetEstConvocatoriaID);
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;				
	}	
	
	function getDetEstConv_CountDelete($DetEstConvocatoriaID)	
	{
		$vConsulta="SELECT COUNT(arc_con_id) FROM archivos_convocatoria 
		WHERE det_est_con_id=".$DetEstConvocatoriaID;
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;				
	}
	
	function eliminarDetEstConv($DetEstConvocatoriaID)	
	{
		$strSQL="DELETE FROM detalle_estado_convocatoria WHERE det_est_con_id=".intval($DetEstConvocatoriaID);
		$oConexion= new ConexionClass();
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
}
?>