<?php
class EstadoConvocatoriaClass{
	public $EstadoConvocatoriaID;
	public $EstadoConvocatoriaDescripcion;
	public $EstadoConvocatoriaActivo;
	
	function listarEstadoConvocatoriaTodos($nombreEstadoConvocatoria,$pagina)
	{
		if(trim($nombreEstadoConvocatoria)!="")
		{
			$vConsulta="SELECT est_con_id, est_con_descripcion, est_con_activo	FROM estado_convocatoria 
 WHERE est_con_descripcion LIKE '%".$nombreEstadoConvocatoria."%' ORDER BY est_con_descripcion";
		}
		else
		{
			$vConsulta="SELECT est_con_id, est_con_descripcion, est_con_activo FROM estado_convocatoria ORDER BY est_con_descripcion";
		}
		$oConexion= new ConexionClass();
		$rscargo=$oConexion->Ejecutar_Consulta($vConsulta);
		$numeroRegistros=$rscargo->num_rows;
		$tamPag=20; 
    	//pagina actual si no esta definida y limites 
    	if(!isset($pagina))
		{	
			$pagina=1; 
       		$inicio=1; 
       		$final=$tamPag;
		}
		else
		{ 
       		$pagina = $pagina; 
    	} 
    	//calculo del limite inferior 
    	$limitInf=($pagina-1)*$tamPag; 

    	//calculo del numero de paginas 
    	$numPags=ceil($numeroRegistros/$tamPag); 
    	if(!isset($pagina)){ 
       		$pagina=1; 
       		$inicio=1; 
       		$final=$tamPag; 
    	}else{ 
       		$seccionActual=intval(($pagina-1)/$tamPag); 
       		$inicio=($seccionActual*$tamPag)+1; 
       		if($pagina<$numPags) 
       		{ 
          		$final=$inicio+$tamPag-1; 
       		}
			else
			{ 
          		$final=$numPags; 
       		} 
       		if ($final>$numPags)
			{ 
          		$final=$numPags; 
       		} 
		}
		$vConsulta.=" limit ".$limitInf.",".$tamPag;
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);
		return $rs;
	}
	
	function contarEstadoConvocatoria($nombreEstadoConvocatoria)
	{
		if(trim($nombreEstadoConvocatoria)!="")
		{
			$vConsulta="SELECT est_con_id, est_con_descripcion, est_con_activo	FROM estado_convocatoria 
 WHERE est_con_descripcion LIKE '%".$nombreEstadoConvocatoria."%' ORDER BY est_con_descripcion";
		}
		else
		{
			$vConsulta="SELECT est_con_id, est_con_descripcion, est_con_activo FROM estado_convocatoria ORDER BY est_con_descripcion";
		}
		$oConexion= new ConexionClass();
		$rsarc=$oConexion->Ejecutar_Consulta($vConsulta);
		$nr=$rsarc->num_rows;
		return $nr;
	}
	
	function insertarEstadoConvocatoria()
	{
		$oConexion= new ConexionClass(); 
		$strSQL="INSERT INTO estado_convocatoria (est_con_descripcion, est_con_activo)	VALUES ('".$oConexion->Escapar_Caracteres($this->EstadoConvocatoriaDescripcion)."', '".$oConexion->Escapar_Caracteres($this->EstadoConvocatoriaActivo)."')";
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function actualizarEstadoConvocatoria()
	{
		$oConexion= new ConexionClass();
		$strSQL="UPDATE estado_convocatoria SET est_con_descripcion = '".$oConexion->Escapar_Caracteres($this->EstadoConvocatoriaDescripcion)."', 	est_con_activo = '".$oConexion->Escapar_Caracteres($this->EstadoConvocatoriaActivo)."' WHERE est_con_id = ".intval($this->EstadoConvocatoriaID);
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function eliminarEstadoConvocatoria($EstadoConvocatoriaID)	
	{
		$strSQL="DELETE FROM estado_convocatoria WHERE est_con_id=".intval($EstadoConvocatoriaID);
		$oConexion= new ConexionClass();
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function getEstadoConvocatoria($EstadoConvocatoriaID)
	{
		$vConsulta="SELECT est_con_id, est_con_descripcion, est_con_activo WHERE est_con_id=".intval($EstadoConvocatoriaID);
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;	
			
	}	
		function getListEstadoConvocatoriaActivos()
	{
		$vConsulta="SELECT est_con_id, est_con_descripcion, est_con_activo FROM estado_convocatoria WHERE est_con_activo=1";
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
			return $rs;		
	}
}
?>