<?php
class EstadoObraClass{
	public $EstadoObraID;
	public $EstadoObraDescripcion;
	public $EstadoObraActivo;
	
	function listarEstadoObraTodos($nombreEstadoObra,$pagina)
	{
		if(trim($nombreEstadoObra)!="")
		{
			$vConsulta="SELECT est_id, est_descripcion, est_activo FROM estado_obra WHERE est_con_descripcion LIKE '%".$nombreEstadoObra."%' ORDER BY est_descripcion";
		}
		else
		{
			$vConsulta="SELECT est_id, est_descripcion, est_activo FROM estado_obra ORDER BY est_con_descripcion";
		}
		$oConexion= new ConexionClass();
		$rscargo=$oConexion->Ejecutar_Consulta($vConsulta);
		$numeroRegistros=$rscargo->num_rows;
		$tamPag=20; 
    	//pagina actual si no esta definida y limites 
    	if(!isset($pagina))
		{	
			$pagina=1; 
       		$inicio=1; 
       		$final=$tamPag;
		}
		else
		{ 
       		$pagina = $pagina; 
    	} 
    	//calculo del limite inferior 
    	$limitInf=($pagina-1)*$tamPag; 

    	//calculo del numero de paginas 
    	$numPags=ceil($numeroRegistros/$tamPag); 
    	if(!isset($pagina)){ 
       		$pagina=1; 
       		$inicio=1; 
       		$final=$tamPag; 
    	}else{ 
       		$seccionActual=intval(($pagina-1)/$tamPag); 
       		$inicio=($seccionActual*$tamPag)+1; 
       		if($pagina<$numPags) 
       		{ 
          		$final=$inicio+$tamPag-1; 
       		}
			else
			{ 
          		$final=$numPags; 
       		} 
       		if ($final>$numPags)
			{ 
          		$final=$numPags; 
       		} 
		}
		$vConsulta.=" limit ".$limitInf.",".$tamPag;
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);
		return $rs;
	}
	
	function contarEstadoObra($nombreEstadoObra)
	{
		if(trim($nombreEstadoObra)!="")
		{
			$vConsulta="SELECT est_id, est_descripcion, est_activo FROM estado_obra WHERE est_con_descripcion LIKE '%".$nombreEstadoObra."%' ORDER BY est_descripcion";
		}
		else
		{
			$vConsulta="SELECT est_id, est_descripcion, est_activo FROM estado_obra ORDER BY est_con_descripcion";
		}
		$oConexion= new ConexionClass();
		$rsarc=$oConexion->Ejecutar_Consulta($vConsulta);
		$nr=$rsarc->num_rows;
		return $nr;
	}
	
	function insertarEstadoObra()
	{
		$oConexion= new ConexionClass(); 
		$strSQL="INSERT INTO estado_obra (est_descripcion, est_activo) VALUES('".$oConexion->Escapar_Caracteres($this->EstadoObraDescripcion)."', '".$oConexion->Escapar_Caracteres($this->EstadoObraActivo)."')";
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function actualizarEstadoObra()
	{
		$oConexion= new ConexionClass();
		$strSQL="UPDATE estado_obra SET est_descripcion = '".$oConexion->Escapar_Caracteres($this->EstadoObraDescripcion)."', est_activo = '".$oConexion->Escapar_Caracteres($this->EstadoObraActivo)."'	WHERE est_id = ".intval($this->EstadoObraID);		
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function eliminarEstadoObra($EstadoObraID)	
	{
		$strSQL="DELETE FROM estado_obra WHERE est_id=".intval($EstadoObraID);
		$oConexion= new ConexionClass();
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function getEstadoObra($EstadoObraID)
	{
		$vConsulta="SELECT est_id, est_descripcion, est_activo FROM estado_obra WHERE est_id=".intval($EstadoObraID);
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;	
			
	}			
	
	function getListEstadoObraActivo()
	{
		$vConsulta="SELECT est_id, est_descripcion, est_activo FROM estado_obra WHERE est_activo=1";
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);	
		 return $rs;
	}
}
?>