<?php
class FuncionarioClass{
	public $FuncionarioID;
	public $FuncionarioDNI;
	public $FuncionarioNombre;
	public $FuncionarioCargo;
	public $FuncionarioEmail;
	public $FuncionarioFoto;
	public $FuncionarioHojaVida;
	public $FuncionarioDeclaracionJurada;
	public $FuncionarioActivo;
	public $tipoFuncionarioID;
	public $PeriodoID;
	
	function listarFuncionarioTodos($FuncionarioNombre,$pagina,$tipoFun,$cant)
	{
		$vConsulta="SELECT funcionario_id, dni, funcionario.nombre, cargo, email,
		foto, funcionario.activo, funcionario.tipo_funcionario_id, periodo_id,
		tipo_funcionario.nombre  as tp_nombre
		FROM funcionario 
		INNER JOIN tipo_funcionario ON funcionario.tipo_funcionario_id=tipo_funcionario.tipo_funcionario_id
		WHERE funcionario.nombre LIKE '%".$FuncionarioNombre."%' 
		AND funcionario.tipo_funcionario_id LIKE '%".$tipoFun."%' 
		ORDER BY tipo_funcionario.nombre,funcionario_id  "; 
		$oConexion= new ConexionClass();
		$rscargo=$oConexion->Ejecutar_Consulta($vConsulta);
		$numeroRegistros=$rscargo->num_rows;
		$tamPag=$cant; 
    	//pagina actual si no esta definida y limites 
    	if(!isset($pagina))
		{	
			$pagina=1; 
       		$inicio=1; 
       		$final=$tamPag;
		}
		else
		{ 
       		$pagina = $pagina; 
    	} 
    	//calculo del limite inferior 
    	$limitInf=($pagina-1)*$tamPag; 

    	//calculo del numero de paginas 
    	$numPags=ceil($numeroRegistros/$tamPag); 
    	if(!isset($pagina)){ 
       		$pagina=1; 
       		$inicio=1; 
       		$final=$tamPag; 
    	}else{ 
       		$seccionActual=intval(($pagina-1)/$tamPag); 
       		$inicio=($seccionActual*$tamPag)+1; 
       		if($pagina<$numPags) 
       		{ 
          		$final=$inicio+$tamPag-1; 
       		}
			else
			{ 
          		$final=$numPags; 
       		} 
       		if ($final>$numPags)
			{ 
          		$final=$numPags; 
       		} 
		}
		$vConsulta.=" limit ".$limitInf.",".$tamPag;
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);
		return $rs;
	}
	
	function contarFuncionario($FuncionarioNombre,$tipoFun)
	{
		$vConsulta="SELECT funcionario_id, dni, funcionario.nombre, cargo, email,
		foto, funcionario.activo, funcionario.tipo_funcionario_id, periodo_id,
		tipo_funcionario.nombre as tp_nombre
		FROM funcionario 
		INNER JOIN tipo_funcionario ON funcionario.tipo_funcionario_id=tipo_funcionario.tipo_funcionario_id
		WHERE funcionario.nombre LIKE '%".$FuncionarioNombre."%' 
		AND funcionario.tipo_funcionario_id LIKE '%".$tipoFun."%' 
		ORDER BY tipo_funcionario.nombre"; 
		$oConexion= new ConexionClass();
		$rsarc=$oConexion->Ejecutar_Consulta($vConsulta);
		$nr=$rsarc->num_rows;
		return $nr;
	}
	
	function getFuncionarioCountDNINew($dni)
	{
		$vConsulta="SELECT COUNT(funcionario_id) AS cant FROM funcionario WHERE activo='1' AND dni='".$dni."'";
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;	
	}
	
	function insertarFuncionario()
	{
		$oConexion= new ConexionClass(); 
		$strSQL="INSERT INTO funcionario (dni, nombre, cargo, email, foto, activo, tipo_funcionario_id, periodo_id) VALUES ('".$oConexion->Escapar_Caracteres($this->FuncionarioDNI)."', '".$oConexion->Escapar_Caracteres($this->FuncionarioNombre)."', '".$oConexion->Escapar_Caracteres($this->FuncionarioCargo)."', '".$oConexion->Escapar_Caracteres($this->FuncionarioEmail)."','', '".$oConexion->Escapar_Caracteres($this->FuncionarioActivo)."', ".intval($this->tipoFuncionarioID).",  ".intval($this->PeriodoID).")";
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function getFuncionarioID()
	{
		$vConsulta="SELECT funcionario_id FROM funcionario ORDER BY funcionario_id DESC LIMIT 1";
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;				
	}
	
	function actualizarFoto()
	{
		$oConexion= new ConexionClass();
		$strSQL="UPDATE funcionario SET foto = '".$oConexion->Escapar_Caracteres($this->FuncionarioFoto)."' 
		WHERE funcionario_id=".intval($this->FuncionarioID);
		return $oConexion->Ejecutar_SQL($strSQL);
	}
		
	function getFuncionario($FuncionarioID)
	{
		$vConsulta="SELECT funcionario_id, dni, nombre, cargo, email, foto, activo, tipo_funcionario_id, periodo_id FROM funcionario WHERE funcionario_id=".intval($FuncionarioID);
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;			
	}	
	
	function getFuncionarioCountDNIUpdate($dni,$funcionarioID)
	{
		$vConsulta="SELECT COUNT(funcionario_id) AS cant FROM funcionario WHERE activo='1' AND dni='".$dni."' AND funcionario_id!=".intval($funcionarioID);
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;	
	}
	
	function actualizarFuncionario()
	{
		$oConexion= new ConexionClass();
		$strSQL="UPDATE funcionario SET dni = '".$oConexion->Escapar_Caracteres($this->FuncionarioDNI)."', nombre = '".$oConexion->Escapar_Caracteres($this->FuncionarioNombre)."', cargo = '".$oConexion->Escapar_Caracteres($this->FuncionarioCargo)."', email = '".$oConexion->Escapar_Caracteres($this->FuncionarioEmail)."', activo = '".$oConexion->Escapar_Caracteres($this->FuncionarioActivo)."', tipo_funcionario_id = ".intval($this->tipoFuncionarioID).", periodo_id = ".intval($this->PeriodoID)." WHERE funcionario_id = ".intval($this->FuncionarioID);	
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function eliminarFuncionario($FuncionarioID)	
	{
		$strSQL="DELETE FROM funcionario WHERE funcionario_id=".intval($FuncionarioID);
		$oConexion= new ConexionClass();
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function getListFuncionarioTIPOID($tfID)
	{
		$vConsulta="SELECT funcionario_id, dni, nombre, cargo, email, foto, activo, tipo_funcionario_id, periodo_id, celular FROM funcionario WHERE activo=1 AND tipo_funcionario_id=".intval($tfID);
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);
			return $rs;
	}	
}
?>