<?php
class GaleriaObraClass{
	public $GaleriaObraID;
	public $GaleriaObraImagen;
	public $GaleriaObraPieImagen;
	public $ObraID;
	
	function listarGaleriaObraTodos($obraID,$pagina)
	{
		$vConsulta="SELECT gal_obr_id, gal_obr_imagen, gal_obr_pie_imagen, obra_id FROM galeria_obra WHERE obra_id = ".$obraID." ORDER BY gal_obr_id";		
		$oConexion= new ConexionClass();
		$rsgaleriaobra=$oConexion->Ejecutar_Consulta($vConsulta);
		$numeroRegistros=$rsgaleriaobra->num_rows;
		$tamPag=200; 
    	//pagina actual si no esta definida y limites 
    	if(!isset($pagina))
		{	
			$pagina=1; 
       		$inicio=1; 
       		$final=$tamPag;
		}
		else
		{ 
       		$pagina = $pagina; 
    	} 
    	//calculo del limite inferior 
    	$limitInf=($pagina-1)*$tamPag; 

    	//calculo del numero de paginas 
    	$numPags=ceil($numeroRegistros/$tamPag); 
    	if(!isset($pagina)){ 
       		$pagina=1; 
       		$inicio=1; 
       		$final=$tamPag; 
    	}else{ 
       		$seccionActual=intval(($pagina-1)/$tamPag); 
       		$inicio=($seccionActual*$tamPag)+1; 
       		if($pagina<$numPags) 
       		{ 
          		$final=$inicio+$tamPag-1; 
       		}
			else
			{ 
          		$final=$numPags; 
       		} 
       		if ($final>$numPags)
			{ 
          		$final=$numPags; 
       		} 
		}
		$vConsulta.=" limit ".$limitInf.",".$tamPag;
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);
		return $rs;
	}
	
	function contarGaleriaObra($GaleriaObraID)
	{
		if(trim($GaleriaObraID)!="")
		{
			$vConsulta="SELECT gal_obr_id, gal_obr_imagen, gal_obr_pie_imagen, obra_id FROM galeria_obra WHERE gal_obr_id LIKE '%".$GaleriaObraID."%' ORDER BY gal_obr_id";
		}
		else
		{
			$vConsulta="SELECT gal_obr_id, gal_obr_imagen, gal_obr_pie_imagen, obra_id FROM galeria_obra ORDER BY gal_obr_id";
		}
		$oConexion= new ConexionClass();
		$rsarc=$oConexion->Ejecutar_Consulta($vConsulta);
		$nr=$rsarc->num_rows;
		return $nr;
	}
	
	function insertarGaleriaObra()
	{
		$oConexion= new ConexionClass(); 
		$strSQL="INSERT INTO galeria_obra (gal_obr_imagen,gal_obr_pie_imagen,obra_id)	VALUES	('','',".intval($this->ObraID).")";
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function getGaleriaObraID()
	{
		$vConsulta="SELECT gal_obr_id FROM galeria_obra ORDER BY gal_obr_id DESC LIMIT 1";
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;				
	}
	
	function actualizarFoto()
	{
		$oConexion= new ConexionClass();
		$strSQL="UPDATE galeria_obra SET gal_obr_imagen = '".$oConexion->Escapar_Caracteres($this->GaleriaObraImagen)."', gal_obr_pie_imagen = '".$oConexion->Escapar_Caracteres($this->GaleriaObraPieImagen)."'  WHERE gal_obr_id=".intval($this->GaleriaObraID);
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function getGaleriaObra($GaleriaObraID)
	{
		$vConsulta="SELECT gal_obr_id, gal_obr_imagen, gal_obr_pie_imagen, obra_id FROM galeria_obra WHERE gal_obr_id=".intval($GaleriaObraID);
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;			
	}	
	
	function eliminarGaleriaObra($GaleriaObraID)	
	{
		$strSQL="DELETE FROM galeria_obra WHERE gal_obr_id=".intval($GaleriaObraID);
		$oConexion= new ConexionClass();
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function getGaleriaObraPrimera($ObraID)
	{
		$vConsulta="SELECT gal_obr_id, gal_obr_imagen, gal_obr_pie_imagen, obra_id FROM galeria_obra WHERE obra_id=".intval($ObraID)." LIMIT 1";
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;			
	}	
	
	function getListGaleriaObras($ObraID)
	{
		$vConsulta="SELECT gal_obr_id, gal_obr_imagen, gal_obr_pie_imagen, obra_id FROM galeria_obra WHERE obra_id=".intval($ObraID);
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
			return $rs;			
	}	
}
?>