<?php
class MenuClass{
	public $menuID;
	public $menuDescripcion;	
	public $menuActivo;
	public $menuEditable;
	public $menuRuta;
	
	function listarMenuTodos($descripcionMenu,$pagina)
	{
		if(trim($descripcionMenu)!="")
		{
			$vConsulta="SELECT 	menu_id, menu_descripcion, menu_activo, menu_editable, 	
			menu_ruta FROM menu WHERE menu_descripcion like '%".$descripcionMenu."%' order by menu_descripcion";
		}
		else
		{
			$vConsulta="SELECT 	menu_id, menu_descripcion, menu_activo, menu_editable, 	
			menu_ruta FROM menu order by menu_descripcion";
		}
		$oConexion= new ConexionClass();
		$rscargo=$oConexion->Ejecutar_Consulta($vConsulta);
		$numeroRegistros=$rscargo->num_rows;
		$tamPag=20; 
    	//pagina actual si no esta definida y limites 
    	if(!isset($pagina))
		{	
			$pagina=1; 
       		$inicio=1; 
       		$final=$tamPag;
		}
		else
		{ 
       		$pagina = $pagina; 
    	} 
    	//calculo del limite inferior 
    	$limitInf=($pagina-1)*$tamPag; 

    	//calculo del numero de paginas 
    	$numPags=ceil($numeroRegistros/$tamPag); 
    	if(!isset($pagina)){ 
       		$pagina=1; 
       		$inicio=1; 
       		$final=$tamPag; 
    	}else{ 
       		$seccionActual=intval(($pagina-1)/$tamPag); 
       		$inicio=($seccionActual*$tamPag)+1; 
       		if($pagina<$numPags) 
       		{ 
          		$final=$inicio+$tamPag-1; 
       		}
			else
			{ 
          		$final=$numPags; 
       		} 
       		if ($final>$numPags)
			{ 
          		$final=$numPags; 
       		} 
		}
		$vConsulta.=" limit ".$limitInf.",".$tamPag;
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);
		return $rs;
	}
	
	function contarMenus($descripcionMenu)
	{
		if(trim($descripcionMenu)!="")
		{
			$vConsulta="SELECT 	menu_id, menu_descripcion, menu_activo, menu_editable, 	
			menu_ruta FROM menu WHERE menu_descripcion like '%".$descripcionMenu."%' order by menu_descripcion";
		}
		else
		{
			$vConsulta="SELECT 	menu_id, menu_descripcion, menu_activo, menu_editable, 	
			menu_ruta FROM menu order by menu_descripcion";
		}
		$oConexion= new ConexionClass();
		$rsarc=$oConexion->Ejecutar_Consulta($vConsulta);
		$nr=$rsarc->num_rows;
		return $nr;
	}
	
	function insertarMenus()
	{
		$oConexion= new ConexionClass(); 
		$strSQL="INSERT INTO menu (menu_descripcion, menu_activo, 	menu_editable, menu_ruta) VALUES('".$oConexion->Escapar_Caracteres($this->menuDescripcion)."', '".$oConexion->Escapar_Caracteres($this->menuActivo)."', '".$oConexion->Escapar_Caracteres($this->menuEditable)."', '".$oConexion->Escapar_Caracteres($this->menuRuta)."')";
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function actualizarMenus()
	{
		$oConexion= new ConexionClass();
		$strSQL="UPDATE menu SET menu_descripcion = '".$oConexion->Escapar_Caracteres($this->menuDescripcion)."', menu_activo = '".$oConexion->Escapar_Caracteres($this->menuActivo)."', menu_editable = '".$oConexion->Escapar_Caracteres($this->menuEditable)."', menu_ruta = '".$oConexion->Escapar_Caracteres($this->menuRuta)."' WHERE	menu_id = ".intval($this->menuID);
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function eliminarMenus($menuID)
	{
		$strSQL="DELETE FROM menu WHERE menu_id=".intval($menuID);
		$oConexion= new ConexionClass();
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function getMenus($menuID)
	{
		$vConsulta="SELECT menu_id, menu_descripcion, menu_activo, menu_editable, 	
		menu_ruta FROM menu WHERE menu_id=".intval($menuID);
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;	
			
	}
	
	function getMenuPagina($pag)
	{
		$vConsulta="SELECT menu_id, menu_descripcion, menu_activo, menu_editable, 
		menu_ruta, menu_tipo, menu_pag 
		FROM menu WHERE menu_pag=".intval($pag);
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;	
			
	}	
		function getMenuActual()
	{
		$vConsulta="SELECT menu_id, menu_descripcion, menu_activo, menu_editable, 	
		menu_ruta FROM menu WHERE menu_activo=1";
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;	
			
	}
	
	function listadoMenu()
	{
		$vConsulta="SELECT menu_id, menu_descripcion, menu_ruta 
		FROM menu WHERE menu_activo='1' AND menu_tipo='M' ";
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);
		return $rs;
	}	
	
	function listadoMenuOtros()
	{
		$vConsulta="SELECT menu_id, menu_descripcion, menu_ruta FROM menu WHERE menu_activo='1'
		AND menu_tipo='O' ";
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);
		return $rs;
	}	
	
	function listadoMenuEditable()
	{
		$vConsulta="SELECT menu_id, menu_descripcion, menu_ruta FROM menu WHERE menu_editable='1' AND menu_activo='1' ";
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);
		return $rs;
	}
	
	
	
	function listadoMenuHorizontal()
	{
		$vConsulta="SELECT menu_id, menu_descripcion, menu_ruta FROM menu WHERE menu_tipo='H' AND menu_activo='1' ORDER BY menu_orden";
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);
		return $rs;
	}
	
	function listadoMenuVertical()
	{
		$vConsulta="SELECT menu_id, menu_descripcion, menu_ruta, menu_imagen FROM menu
		WHERE menu_tipo='V' AND menu_activo='1'			
		ORDER BY menu_id ";
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);
		return $rs;
	}
	
	function listadoMenuVerticalMen($menu)
	{
		$vConsulta="SELECT menu_id, menu_descripcion, menu_ruta, menu_imagen FROM menu
		WHERE menu_tipo='V' AND menu_activo='1' 
		AND menu_id!=".$menu."		
		ORDER BY menu_id ";
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);
		return $rs;
	}
	
}
?>