<?php
class ModuloOpcionesClass{
	public $modOpcID;
	public $modOpcNombre;	
	public $modOpcArchivo;	
	public $modID;		
	
	function listarModuloOpcionesTodos($nombreModuloOpciones,$pagina)
	{
		if(trim($nombreModuloOpciones)!="")
		{
			$vConsulta="SELECT mod_opc_id, mod_opc_nombre, mod_opc_archivo, mod_id FROM modulo_opciones WHERE mod_opc_nombre like '%".$nombreModuloOpciones."%' order by mod_opc_nombre";
		}
		else
		{
			$vConsulta="SELECT mod_opc_id, mod_opc_nombre, mod_opc_archivo, mod_id FROM modulo_opciones";
		}
		$oConexion= new ConexionClass();
		$rsModOpc=$oConexion->Ejecutar_Consulta($vConsulta);
		$numeroRegistros=$rsModOpc->num_rows;
		$tamPag=20; 
    	//pagina actual si no esta definida y limites 
    	if(!isset($pagina))
		{	
			$pagina=1; 
       		$inicio=1; 
       		$final=$tamPag;
		}
		else
		{ 
       		$pagina = $pagina; 
    	} 
    	//calculo del limite inferior 
    	$limitInf=($pagina-1)*$tamPag; 

    	//calculo del numero de paginas 
    	$numPags=ceil($numeroRegistros/$tamPag); 
    	if(!isset($pagina)){ 
       		$pagina=1; 
       		$inicio=1; 
       		$final=$tamPag; 
    	}else{ 
       		$seccionActual=intval(($pagina-1)/$tamPag); 
       		$inicio=($seccionActual*$tamPag)+1; 
       		if($pagina<$numPags) 
       		{ 
          		$final=$inicio+$tamPag-1; 
       		}
			else
			{ 
          		$final=$numPags; 
       		} 
       		if ($final>$numPags)
			{ 
          		$final=$numPags; 
       		} 
		}
		$vConsulta.=" limit ".$limitInf.",".$tamPag;
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);
		return $rs;
	}
	
	function contarModuloOpciones($nombreModuloOpciones)
	{
		if(trim($nombreModuloOpciones)!="")
		{
			$vConsulta="SELECT mod_opc_id, mod_opc_nombre, mod_opc_archivo, mod_id FROM modulo_opciones WHERE mod_opc_nombre like '%".$nombreModuloOpciones."%' order by mod_opc_nombre";
		}
		else
		{
			$vConsulta="SELECT mod_opc_id, mod_opc_nombre, mod_opc_archivo, mod_id FROM modulo_opciones";
		}
		$oConexion= new ConexionClass();
		$rsarc=$oConexion->Ejecutar_Consulta($vConsulta);
		$nr=$rsarc->num_rows;
		return $nr;
	}
	
	function insertarModuloOpciones()
	{
		$oConexion= new ConexionClass(); 
		$strSQL="INSERT INTO modulo_opciones (mod_opc_nombre, mod_opc_archivo, mod_id) VALUES	('".$oConexion->Escapar_Caracteres($this->modOpcNombre)."', '".$oConexion->Escapar_Caracteres($this->modOpcArchivo)."', ".intval($this->modID).")";
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function actualizarModuloOpciones()
	{
		$oConexion= new ConexionClass();
		$strSQL="UPDATE modulo_opciones SET mod_opc_nombre = '".$oConexion->Escapar_Caracteres($this->modOpcNombre)."', mod_opc_archivo = '".$oConexion->Escapar_Caracteres($this->modOpcArchivo)."', mod_id = ".intval($this->modID)." WHERE mod_opc_id = ".intval($this->modOpcID);
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function eliminarModuloOpciones()	
	{
		$strSQL="DELETE FROM modulo_opciones WHERE mod_opc_id=".intval($this->modOpcID);
		$oConexion= new ConexionClass();
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function getModuloOpciones($modOpcID)
	{
		$vConsulta="SELECT  mod_opc_id, mod_opc_nombre, mod_opc_archivo FROM modulo_opciones WHERE mod_opc_id=".intval($modOpcID);
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;			
	}
	
	function listadoOpcionesModulo($moduloID)
	{
		$vConsulta="SELECT mod_opc_id, mod_opc_nombre, mod_opc_archivo FROM modulo_opciones WHERE mod_id=".intval($moduloID)." ORDER BY mod_opc_id ";
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);
		return $rs;
	}
	
	function countOpcionesIDMODULO($moduloID)
	{
		$vConsulta="SELECT count(mod_opc_id) FROM modulo_opciones WHERE mod_id =".intval($moduloID);		
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;		
	}
	
	function getListModOpciones()
	{
		$vConsulta="SELECT mod_opc_id, mod_opc_nombre, mod_id FROM modulo_opciones 
				WHERE mod_id=".intval($this->modID)." ORDER BY mod_opc_id ASC ";
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);
		return $rs;
	}
}
?>