<?php
class MuniGaleriaClass{
	public $mg_id;
	public $mg_fecha;
	public $mg_titulo;
	public $mg_cuerpo;	
	
function listarMuniGaleriasTodos($titulo,$pagina,$cant)
	{
		$vConsulta="SELECT mg_id, mg_fecha, mg_titulo, mg_cuerpo FROM munigaleria WHERE mg_titulo LIKE '%".$titulo."%' ORDER BY mg_fecha DESC ";		
		$oConexion= new ConexionClass();
		$rsobra=$oConexion->Ejecutar_Consulta($vConsulta);
		$numeroRegistros=$rsobra->num_rows;
		$tamPag=$cant; 
    	//pagina actual si no esta definida y limites 
    	if(!isset($pagina))
		{	
			$pagina=1; 
       		$inicio=1; 
       		$final=$tamPag;
		}
		else
		{ 
       		$pagina = $pagina; 
    	} 
    	//calculo del limite inferior 
    	$limitInf=($pagina-1)*$tamPag; 

    	//calculo del numero de paginas 
    	$numPags=ceil($numeroRegistros/$tamPag); 
    	if(!isset($pagina)){ 
       		$pagina=1; 
       		$inicio=1; 
       		$final=$tamPag; 
    	}else{ 
       		$seccionActual=intval(($pagina-1)/$tamPag); 
       		$inicio=($seccionActual*$tamPag)+1; 
       		if($pagina<$numPags) 
       		{ 
          		$final=$inicio+$tamPag-1; 
       		}
			else
			{ 
          		$final=$numPags; 
       		} 
       		if ($final>$numPags)
			{ 
          		$final=$numPags; 
       		} 
		}
		$vConsulta.=" limit ".$limitInf.",".$tamPag;
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);
		return $rs;
	}
	
	function contarMuniGalerias($titulo)
	{
		$vConsulta="SELECT mg_id, mg_fecha, mg_titulo, mg_cuerpo FROM munigaleria WHERE mg_titulo LIKE '%".$titulo."%' ORDER BY mg_fecha DESC ";		
		$oConexion= new ConexionClass();
		$rsarc=$oConexion->Ejecutar_Consulta($vConsulta);
		$nr=$rsarc->num_rows;
		return $nr;
	}
	
	function insertarMuniGaleria()
	{
		$oConexion= new ConexionClass(); 
		$strSQL="INSERT INTO munigaleria (mg_fecha, mg_titulo, mg_cuerpo) VALUES ('".$oConexion->Escapar_Caracteres($this->mg_fecha)."', '".$this->mg_titulo."', '".$oConexion->Escapar_Caracteres($this->mg_cuerpo)."')";
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function getMuniGaleria($mgID)	
	{
		$vConsulta="SELECT mg_id, mg_fecha, mg_titulo, mg_cuerpo FROM munigaleria WHERE mg_id=".intval($mgID);
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;				
	}	
	
	function actualizarMuniGaleria()
	{
		$oConexion= new ConexionClass();
		$strSQL="UPDATE munigaleria SET mg_fecha = '".$oConexion->Escapar_Caracteres($this->mg_fecha)."', mg_titulo = '".$this->mg_titulo."', mg_cuerpo = '".$oConexion->Escapar_Caracteres($this->mg_cuerpo)."' WHERE mg_id = ".intval($this->mg_id);		
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function getCountMuniGaleria($mgID)
	{
		$vConsulta="SELECT count(mgd_id) FROM munigaleria_detalle WHERE mg_id=".intval($mgID);
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;				
	}	
	
	function eliminarMuniGaleria($mgID)	
	{
		$strSQL="DELETE FROM munigaleria WHERE mg_id=".intval($mgID);
		$oConexion= new ConexionClass();
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function getListUltimasMuniGalerias($inicio, $cant)
	{
		$vConsulta="SELECT mg_id, mg_fecha, mg_titulo, mg_cuerpo FROM munigaleria
		where mg_id!=1 ORDER BY mg_fecha DESC, mg_id DESC LIMIT ".$inicio.",".$cant;
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		 return $rs;	
	}
	
	function getListMuniGaleriasFechas($fechaIni,$fechaFin,$pagina,$cant)
	{
		$vConsulta="SELECT mg_id, mg_fecha, mg_titulo, mg_cuerpo FROM munigaleria 		
		WHERE mg_fecha BETWEEN '".$fechaIni."' AND '".$fechaFin."'  
		ORDER BY mg_fecha DESC,mg_id DESC";
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);
		$numeroRegistros=$rs->num_rows;
		$tamPag=$cant; 
    	//pagina actual si no esta definida y limites 
    	if(!isset($pagina))
		{	
			$pagina=1; 
       		$inicio=1; 
       		$final=$tamPag;
		}
		else
		{ 
       		$pagina = $pagina; 
    	} 
    	//calculo del limite inferior 
    	$limitInf=($pagina-1)*$tamPag; 

    	//calculo del numero de paginas 
    	$numPags=ceil($numeroRegistros/$tamPag); 
    	if(!isset($pagina)){ 
       		$pagina=1; 
       		$inicio=1; 
       		$final=$tamPag; 
    	}else{ 
       		$seccionActual=intval(($pagina-1)/$tamPag); 
       		$inicio=($seccionActual*$tamPag)+1; 
       		if($pagina<$numPags) 
       		{ 
          		$final=$inicio+$tamPag-1; 
       		}
			else
			{ 
          		$final=$numPags; 
       		} 
       		if ($final>$numPags)
			{ 
          		$final=$numPags; 
       		} 
		}
		$vConsulta.=" limit ".$limitInf.",".$tamPag;
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		 return $rs;	
	}
	
	function contarMuniGaleriasFechas($fechaIni,$fechaFin)
	{
		$vConsulta="SELECT mg_id, mg_fecha, mg_titulo, mg_cuerpo FROM munigaleria 		
		WHERE mg_fecha BETWEEN '".$fechaIni."' AND '".$fechaFin."'  
		ORDER BY mg_fecha DESC,mg_id DESC";
		$oConexion= new ConexionClass();
		$rsarc=$oConexion->Ejecutar_Consulta($vConsulta);
		$nr=$rsarc->num_rows;
		return $nr;
	}	
	
	
	
	function getListMuniGaleriasPW($pagina,$cant)
	{
		$vConsulta="SELECT mg_id, mg_fecha, mg_titulo, mg_cuerpo FROM munigaleria 		
		WHERE mg_id!=1
		ORDER BY mg_fecha DESC, mg_id DESC ";
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);
		$numeroRegistros=$rs->num_rows;
		$tamPag=$cant; 
    	//pagina actual si no esta definida y limites 
    	if(!isset($pagina))
		{	
			$pagina=1; 
       		$inicio=1; 
       		$final=$tamPag;
		}
		else
		{ 
       		$pagina = $pagina; 
    	} 
    	//calculo del limite inferior 
    	$limitInf=($pagina-1)*$tamPag; 

    	//calculo del numero de paginas 
    	$numPags=ceil($numeroRegistros/$tamPag); 
    	if(!isset($pagina)){ 
       		$pagina=1; 
       		$inicio=1; 
       		$final=$tamPag; 
    	}else{ 
       		$seccionActual=intval(($pagina-1)/$tamPag); 
       		$inicio=($seccionActual*$tamPag)+1; 
       		if($pagina<$numPags) 
       		{ 
          		$final=$inicio+$tamPag-1; 
       		}
			else
			{ 
          		$final=$numPags; 
       		} 
       		if ($final>$numPags)
			{ 
          		$final=$numPags; 
       		} 
		}
		$vConsulta.=" limit ".$limitInf.",".$tamPag;
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		 return $rs;	
	}
	
	function contarMuniGaleriasPW()
	{
		$vConsulta="SELECT mg_id, mg_fecha, mg_titulo, mg_cuerpo FROM munigaleria 		
		WHERE mg_id!=1
		ORDER BY mg_fecha DESC, mg_id DESC";
		$oConexion= new ConexionClass();
		$rsarc=$oConexion->Ejecutar_Consulta($vConsulta);
		$nr=$rsarc->num_rows;
		return $nr;
	}
	
}
?>