<?php
class MuniGaleriaDetalleClass{
	public $mgd_id;
	public $mgd_imagen;
	public $mgd_pie_imagen;
	public $mg_id;
	
	function listarMGDTodos($mgID,$pagina)
	{
		$vConsulta="SELECT mgd_id, mgd_imagen, mgd_pie_imagen, mg_id FROM munigaleria_detalle WHERE mg_id = ".$mgID." ORDER BY mgd_id";		
		$oConexion= new ConexionClass();
		$rsgaleriaobra=$oConexion->Ejecutar_Consulta($vConsulta);
		$numeroRegistros=$rsgaleriaobra->num_rows;
		$tamPag=200; 
    	//pagina actual si no esta definida y limites 
    	if(!isset($pagina))
		{	
			$pagina=1; 
       		$inicio=1; 
       		$final=$tamPag;
		}
		else
		{ 
       		$pagina = $pagina; 
    	} 
    	//calculo del limite inferior 
    	$limitInf=($pagina-1)*$tamPag; 

    	//calculo del numero de paginas 
    	$numPags=ceil($numeroRegistros/$tamPag); 
    	if(!isset($pagina)){ 
       		$pagina=1; 
       		$inicio=1; 
       		$final=$tamPag; 
    	}else{ 
       		$seccionActual=intval(($pagina-1)/$tamPag); 
       		$inicio=($seccionActual*$tamPag)+1; 
       		if($pagina<$numPags) 
       		{ 
          		$final=$inicio+$tamPag-1; 
       		}
			else
			{ 
          		$final=$numPags; 
       		} 
       		if ($final>$numPags)
			{ 
          		$final=$numPags; 
       		} 
		}
		$vConsulta.=" limit ".$limitInf.",".$tamPag;
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);
		return $rs;
	}
		
	function insertarMGD()
	{
		$oConexion= new ConexionClass(); 
		$strSQL="INSERT INTO munigaleria_detalle (mgd_imagen,mgd_pie_imagen,mg_id)	VALUES	('','',".intval($this->mg_id).")";
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function getMGD_ID()
	{
		$vConsulta="SELECT mgd_id FROM munigaleria_detalle ORDER BY mgd_id DESC LIMIT 1";
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;				
	}
	
	function actualizarFoto()
	{
		$oConexion= new ConexionClass();
		$strSQL="UPDATE munigaleria_detalle SET mgd_imagen = '".$oConexion->Escapar_Caracteres($this->mgd_imagen)."', mgd_pie_imagen = '".$oConexion->Escapar_Caracteres($this->mgd_pie_imagen)."'  WHERE mgd_id=".intval($this->mgd_id);
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function getMGD($mgdID)
	{
		$vConsulta="SELECT mgd_id, mgd_imagen, mgd_pie_imagen, mg_id FROM munigaleria_detalle WHERE mgd_id=".intval($mgdID);
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;			
	}	
	
	function eliminarMGD($mgdID)	
	{
		$strSQL="DELETE FROM munigaleria_detalle WHERE mgd_id=".intval($mgdID);
		$oConexion= new ConexionClass();
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function getMGDPrimera($mgID)
	{
		$vConsulta="SELECT mgd_id, mgd_imagen, mgd_pie_imagen, mg_id FROM munigaleria_detalle WHERE mg_id=".intval($mgID)." LIMIT 1";
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;			
	}	
	
	function getListMGD($mgID)
	{
		$vConsulta="SELECT mgd_id, mgd_imagen, mgd_pie_imagen, mg_id FROM munigaleria_detalle  WHERE mg_id=".intval($mgID);
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
			return $rs;			
	}
	
	function getListMuniGaleriasPrincipal($mgID)
	{
		$vConsulta="SELECT mgd_id, mgd_imagen, mgd_pie_imagen, mg_id FROM munigaleria_detalle  WHERE mg_id=".intval($mgID);
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
			return $rs;			
	}	
}
?>