<?php
class NoticiasClass{
	public $notID;
	public $notTitulo;
	public $notFechaIng;
	public $notResumen;
	public $notCuerpo;
	public $notImagen;
	public $notPieImagen;
	public $notLecturas;
	public $notActivo;
	public $notGaleria;
	
	function listarNoticiasTodos($notTitulo,$pagina,$cant)
	{		
		$vConsulta="SELECT 	not_id, not_titulo, not_fecha_ing, not_resumen, not_cuerpo,
		not_imagen, not_pie_imagen, not_lecturas, not_activo
		FROM noticia WHERE not_titulo LIKE '%".$notTitulo."%' ORDER BY not_fecha_ing DESC ";		
		$oConexion= new ConexionClass();
		$rscargo=$oConexion->Ejecutar_Consulta($vConsulta);
		$numeroRegistros=$rscargo->num_rows;
		$tamPag=$cant; 
    	//pagina actual si no esta definida y limites 
    	if(!isset($pagina))
		{	
			$pagina=1; 
       		$inicio=1; 
       		$final=$tamPag;
		}
		else
		{ 
       		$pagina = $pagina; 
    	} 
    	//calculo del limite inferior 
    	$limitInf=($pagina-1)*$tamPag; 

    	//calculo del numero de paginas 
    	$numPags=ceil($numeroRegistros/$tamPag); 
    	if(!isset($pagina)){ 
       		$pagina=1; 
       		$inicio=1; 
       		$final=$tamPag; 
    	}else{ 
       		$seccionActual=intval(($pagina-1)/$tamPag); 
       		$inicio=($seccionActual*$tamPag)+1; 
       		if($pagina<$numPags) 
       		{ 
          		$final=$inicio+$tamPag-1; 
       		}
			else
			{ 
          		$final=$numPags; 
       		} 
       		if ($final>$numPags)
			{ 
          		$final=$numPags; 
       		} 
		}
		$vConsulta.=" limit ".$limitInf.",".$tamPag;
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);
		return $rs;
	}
	
	function contarNoticia($notTitulo)
	{
	  	$vConsulta="SELECT 	not_id, not_titulo, not_fecha_ing, not_resumen, not_cuerpo,
		not_imagen, not_pie_imagen, not_lecturas , not_activo
		FROM noticia WHERE not_titulo LIKE '%".$notTitulo."%' ORDER BY not_fecha_ing DESC ";		
		$oConexion= new ConexionClass();
		$rsarc=$oConexion->Ejecutar_Consulta($vConsulta);
		$nr=$rsarc->num_rows;
		return $nr;
	}
	
	function insertarNoticia()
	{
		$oConexion= new ConexionClass(); 
		$strSQL="INSERT INTO noticia (not_titulo, not_fecha_ing, not_resumen,
		not_cuerpo, not_imagen, not_pie_imagen, not_lecturas, not_activo)
		VALUES ('".$oConexion->Escapar_Caracteres($this->notTitulo)."', 
		'".$oConexion->Escapar_Caracteres($this->notFechaIng)."',
		'".$oConexion->Escapar_Caracteres($this->notResumen)."', 
		'".$this->notCuerpo."', '', '', ".intval($this->notLecturas).",
		'".$oConexion->Escapar_Caracteres($this->notActivo)."')";
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function getNoticiaID()
	{
		$vConsulta="SELECT not_id FROM noticia ORDER BY not_id DESC LIMIT 1";
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;				
	}
	
	function actualizarImagen()
	{
		$oConexion= new ConexionClass();
		$strSQL="UPDATE noticia 
		SET not_imagen = '".$oConexion->Escapar_Caracteres($this->notImagen)."', 
		not_pie_imagen = '".$oConexion->Escapar_Caracteres($this->notPieImagen)."'	
		WHERE not_id=".intval($this->notID);
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function getNoticia($noticiaID)
	{
		$vConsulta="SELECT 	not_id, not_titulo, not_fecha_ing, not_resumen, not_cuerpo,
			not_imagen, not_pie_imagen, not_lecturas , not_activo
			FROM noticia
			WHERE not_id=".intval($noticiaID);
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;	
			
	}
	
	function actualizarNoticia()
	{
		$oConexion= new ConexionClass();
		$strSQL="UPDATE noticia 
		SET	not_titulo = '".$oConexion->Escapar_Caracteres($this->notTitulo)."', 
		not_fecha_ing = '".$oConexion->Escapar_Caracteres($this->notFechaIng)."',
		not_resumen = '".$oConexion->Escapar_Caracteres($this->notResumen)."', 
		not_cuerpo = '".$this->notCuerpo."', 
		not_activo = '".$oConexion->Escapar_Caracteres($this->notActivo)."'
		WHERE not_id = ".intval($this->notID);					
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function eliminarNoticia($notID)	
	{
		$strSQL="DELETE FROM noticia WHERE not_id=".intval($notID);
		$oConexion= new ConexionClass();
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function getUltimaNoticia()
	{
		$vConsulta="SELECT 	not_id, not_titulo, not_fecha_ing, not_resumen, not_cuerpo,
			not_imagen, not_pie_imagen, not_lecturas , not_activo 
			FROM noticia
			WHERE not_activo='1' ORDER BY not_fecha_ing DESC ,not_id DESC LIMIT 0,1 ";
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;	
			
	}
	
	function getListUltimasNoticias($inicio, $cant)
	{
		$vConsulta="SELECT 	not_id, not_titulo, not_fecha_ing, not_resumen, not_cuerpo,
			not_imagen, not_pie_imagen, not_lecturas , not_activo
			FROM noticia WHERE not_activo='1' 
			ORDER BY not_fecha_ing DESC, not_id DESC LIMIT ".$inicio.",".$cant;
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		 return $rs;	
	}
	
	function getListNoticiasFechas($fechaIni,$fechaFin,$pagina,$cant)
	{
		$vConsulta="SELECT 	not_id, not_titulo, not_fecha_ing, not_resumen, not_cuerpo,
			not_imagen, not_pie_imagen, not_lecturas , not_activo
			FROM noticia WHERE not_activo='1' AND
			( not_fecha_ing BETWEEN '".$fechaIni."' AND '".$fechaFin."' ) 
			ORDER BY not_fecha_ing DESC,not_id DESC";
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);
		$numeroRegistros=$rs->num_rows;
		$tamPag=$cant; 
    	//pagina actual si no esta definida y limites 
    	if(!isset($pagina))
		{	
			$pagina=1; 
       		$inicio=1; 
       		$final=$tamPag;
		}
		else
		{ 
       		$pagina = $pagina; 
    	} 
    	//calculo del limite inferior 
    	$limitInf=($pagina-1)*$tamPag; 

    	//calculo del numero de paginas 
    	$numPags=ceil($numeroRegistros/$tamPag); 
    	if(!isset($pagina)){ 
       		$pagina=1; 
       		$inicio=1; 
       		$final=$tamPag; 
    	}else{ 
       		$seccionActual=intval(($pagina-1)/$tamPag); 
       		$inicio=($seccionActual*$tamPag)+1; 
       		if($pagina<$numPags) 
       		{ 
          		$final=$inicio+$tamPag-1; 
       		}
			else
			{ 
          		$final=$numPags; 
       		} 
       		if ($final>$numPags)
			{ 
          		$final=$numPags; 
       		} 
		}
		$vConsulta.=" limit ".$limitInf.",".$tamPag;
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		 return $rs;	
	}
	
	function contarNoticiasFechas($fechaIni,$fechaFin)
	{
		$vConsulta="SELECT 	not_id, not_titulo, not_fecha_ing, not_resumen, not_cuerpo,
			not_imagen, not_pie_imagen, not_lecturas , not_activo
			FROM noticia WHERE not_activo='1' AND
			( not_fecha_ing BETWEEN '".$fechaIni."' AND '".$fechaFin."' ) 
			ORDER BY not_fecha_ing DESC,not_id DESC";
		$oConexion= new ConexionClass();
		$rsarc=$oConexion->Ejecutar_Consulta($vConsulta);
		$nr=$rsarc->num_rows;
		return $nr;
	}
	
	function updateNoticiasVecesLeida($notID)
	{
		$oConexion= new ConexionClass(); 
		$strSQL="UPDATE noticia SET not_lecturas = not_lecturas+1 WHERE not_id=".intval($notID);		
		return $oConexion->Ejecutar_SQL($strSQL);
	}
}
?>