<?php
class ObraClass{
	public $ObraID;
	public $ObraTitulo;
	public $ObraFecha;
	public $ObraPresupuesto;
	public $ObraCuerpo;
	public $EstadoObraID;
	public $CategoriaObraID;
	public $anioID;
	public $ObraActivo;
	
function listadoObraTodos($tituloObra,$pagina,$cant,$estObraID,$anioID)
	{		
		$vConsulta="SELECT obra_id, obra_fecha, obra_titulo, obra_presupuesto, obra_cuerpo, obra.est_id, obra.cat_id, obra.anio_id, obra_activo, cat_descripcion, nombre, est_descripcion 
		FROM obra 
		INNER JOIN categoria_obra ON obra.cat_id=categoria_obra.cat_id
		INNER JOIN estado_obra ON obra.est_id=estado_obra.est_id
		INNER JOIN anio ON obra.anio_id=anio.anio_id
		WHERE obra_titulo LIKE '%".$tituloObra."%' 
		AND obra.est_id LIKE '%".$estObraID."%' 
		AND obra.anio_id LIKE '%".$anioID."%' 
		ORDER BY obra.est_id, nombre DESC, cat_descripcion, obra_fecha DESC ";		
		$oConexion= new ConexionClass();
		$rsobra=$oConexion->Ejecutar_Consulta($vConsulta);
		$numeroRegistros=$rsobra->num_rows;
		$tamPag=$cant; 
    	//pagina actual si no esta definida y limites 
    	if(!isset($pagina))
		{	
			$pagina=1; 
       		$inicio=1; 
       		$final=$tamPag;
		}
		else
		{ 
       		$pagina = $pagina; 
    	} 
    	//calculo del limite inferior 
    	$limitInf=($pagina-1)*$tamPag; 

    	//calculo del numero de paginas 
    	$numPags=ceil($numeroRegistros/$tamPag); 
    	if(!isset($pagina)){ 
       		$pagina=1; 
       		$inicio=1; 
       		$final=$tamPag; 
    	}else{ 
       		$seccionActual=intval(($pagina-1)/$tamPag); 
       		$inicio=($seccionActual*$tamPag)+1; 
       		if($pagina<$numPags) 
       		{ 
          		$final=$inicio+$tamPag-1; 
       		}
			else
			{ 
          		$final=$numPags; 
       		} 
       		if ($final>$numPags)
			{ 
          		$final=$numPags; 
       		} 
		}
		$vConsulta.=" limit ".$limitInf.",".$tamPag;
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);
		return $rs;
	}
	
	function contarObra($tituloObra,$estObraID,$anioID)
	{		
		$vConsulta="SELECT obra_id, obra_fecha, obra_titulo, obra_presupuesto, obra_cuerpo, obra.est_id, obra.cat_id, obra.anio_id, obra_activo, cat_descripcion, nombre, est_descripcion 
		FROM obra 
		INNER JOIN categoria_obra ON obra.cat_id=categoria_obra.cat_id
		INNER JOIN estado_obra ON obra.est_id=estado_obra.est_id
		INNER JOIN anio ON obra.anio_id=anio.anio_id
		WHERE obra_titulo LIKE '%".$tituloObra."%' 
		AND obra.est_id LIKE '%".$estObraID."%' 
		AND obra.anio_id LIKE '%".$anioID."%' 
		ORDER BY obra.est_id, nombre DESC, cat_descripcion, obra_fecha DESC";		
		$oConexion= new ConexionClass();
		$rsarc=$oConexion->Ejecutar_Consulta($vConsulta);
		$nr=$rsarc->num_rows;
		return $nr;
	}
	
	function insertarObra()
	{
		$oConexion= new ConexionClass(); 
		$strSQL="INSERT INTO obra (obra_fecha, obra_titulo, obra_presupuesto, obra_cuerpo, est_id, cat_id, anio_id, obra_activo) VALUES	('".$oConexion->Escapar_Caracteres($this->ObraFecha)."', '".$oConexion->Escapar_Caracteres($this->ObraTitulo)."', '".$oConexion->Escapar_Caracteres($this->ObraPresupuesto)."', '".$this->ObraCuerpo."', ".intval($this->EstadoObraID).", ".intval($this->CategoriaObraID).",".intval($this->anioID).",'".$oConexion->Escapar_Caracteres($this->ObraActivo)."')";
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function getObra($ObraID)	
	{
		$vConsulta="SELECT obra_id, obra_fecha, obra_titulo, obra_presupuesto, 
		obra_cuerpo, estado_obra.est_id, obra.cat_id, obra.anio_id , 
		obra_activo, cat_descripcion , est_descripcion, anio.nombre
		FROM obra INNER JOIN categoria_obra ON obra.cat_id=categoria_obra.cat_id 
		INNER JOIN estado_obra ON obra.est_id=estado_obra.est_id
		INNER JOIN anio ON obra.anio_id=anio.anio_id
		WHERE obra_id=".intval($ObraID);
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;				
	}	
	
	function actualizarObra()
	{
		$oConexion= new ConexionClass();
		$strSQL="UPDATE obra SET obra_fecha = '".$oConexion->Escapar_Caracteres($this->ObraFecha)."', obra_titulo = '".$oConexion->Escapar_Caracteres($this->ObraTitulo)."', obra_presupuesto = '".$oConexion->Escapar_Caracteres($this->ObraPresupuesto)."', obra_cuerpo = '".$this->ObraCuerpo."', est_id = ".intval($this->EstadoObraID).", cat_id = ".intval($this->CategoriaObraID)." , anio_id = ".intval($this->anioID)." , obra_activo = '".$oConexion->Escapar_Caracteres($this->ObraActivo)."'  WHERE obra_id = ".intval($this->ObraID);		
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function getCountObraGaleria($obraID)
	{
		$vConsulta="SELECT count(gal_obr_id) FROM galeria_obra WHERE obra_id=".intval($obraID);
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;				
	}	
	
	function eliminarObra($ObraID)	
	{
		$strSQL="DELETE FROM obra WHERE obra_id=".intval($ObraID);
		$oConexion= new ConexionClass();
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function getListUltimasObrasGalerias($inicio, $cant)
	{
		$vConsulta="SELECT 	obra_id, obra_fecha, obra_titulo, obra_presupuesto, 
		obra_cuerpo,estado_obra.est_id, cat_descripcion, est_descripcion FROM obra 
		INNER JOIN categoria_obra ON obra.cat_id=categoria_obra.cat_id
		INNER JOIN estado_obra ON obra.est_id=estado_obra.est_id
		WHERE obra_activo='1' AND (estado_obra.est_id=1 OR estado_obra.est_id=2)
		ORDER BY obra_fecha DESC, obra_id DESC LIMIT ".$inicio.",".$cant;
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		 return $rs;	
	}
	
	function getListObrasFechas($fechaIni,$fechaFin,$pagina,$cant)
	{
		$vConsulta="SELECT 	obra_id, obra_fecha, obra_titulo, obra_presupuesto, 
		obra_cuerpo,est_id, cat_descripcion FROM obra 
		INNER JOIN categoria_obra ON obra.cat_id=categoria_obra.cat_id 		
		WHERE obra_activo='1'  AND est_id=1 AND
			( obra_fecha BETWEEN '".$fechaIni."' AND '".$fechaFin."' ) 
			ORDER BY obra_fecha DESC,obra_id DESC";
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);
		$numeroRegistros=$rs->num_rows;
		$tamPag=$cant; 
    	//pagina actual si no esta definida y limites 
    	if(!isset($pagina))
		{	
			$pagina=1; 
       		$inicio=1; 
       		$final=$tamPag;
		}
		else
		{ 
       		$pagina = $pagina; 
    	} 
    	//calculo del limite inferior 
    	$limitInf=($pagina-1)*$tamPag; 

    	//calculo del numero de paginas 
    	$numPags=ceil($numeroRegistros/$tamPag); 
    	if(!isset($pagina)){ 
       		$pagina=1; 
       		$inicio=1; 
       		$final=$tamPag; 
    	}else{ 
       		$seccionActual=intval(($pagina-1)/$tamPag); 
       		$inicio=($seccionActual*$tamPag)+1; 
       		if($pagina<$numPags) 
       		{ 
          		$final=$inicio+$tamPag-1; 
       		}
			else
			{ 
          		$final=$numPags; 
       		} 
       		if ($final>$numPags)
			{ 
          		$final=$numPags; 
       		} 
		}
		$vConsulta.=" limit ".$limitInf.",".$tamPag;
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		 return $rs;	
	}
	
	function contarObrasFechas($fechaIni,$fechaFin)
	{
		$vConsulta="SELECT 	obra_id, obra_fecha, obra_titulo, obra_presupuesto, 
		obra_cuerpo,est_id, cat_descripcion FROM obra 
		INNER JOIN categoria_obra ON obra.cat_id=categoria_obra.cat_id 		
		WHERE obra_activo='1'  AND est_id=1 AND 
		( obra_fecha BETWEEN '".$fechaIni."' AND '".$fechaFin."' ) 
			ORDER BY obra_fecha DESC,obra_id DESC";
		$oConexion= new ConexionClass();
		$rsarc=$oConexion->Ejecutar_Consulta($vConsulta);
		$nr=$rsarc->num_rows;
		return $nr;
	}
	
	function getListCategoriaObras($estID)
	{
		$vConsulta="SELECT DISTINCT(obra.cat_id), cat_descripcion,cat_activo	
		FROM obra
		INNER JOIN categoria_obra ON obra.cat_id=categoria_obra.cat_id
		WHERE obra_activo='1' AND est_id=".intval($estID);
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		return $rs;	
	}
	
	function getListObrasCategoria($catID, $estID)
	{
		$vConsulta="SELECT 	obra_id, obra_fecha, obra_titulo, obra_presupuesto, obra_cuerpo,est_id,cat_descripcion
		FROM obra	
		INNER JOIN categoria_obra ON obra.cat_id=categoria_obra.cat_id		
		WHERE obra_activo='1' AND obra.cat_id=".intval($catID)." AND est_id=".intval($estID)."
		ORDER BY obra_fecha DESC, obra_id DESC ";
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		 return $rs;	
	}
	
}
?>