<?php
class PeriodoClass{
	public $PeriodoID;
	public $PeriodoInicio;
	public $PeriodoFin;
	public $PeriodoActivo;
	
	function listarPeriodoTodos($pagina)
		{
			$vConsulta="SELECT 	periodo_id, periodo_inicio, periodo_fin, periodo_activo FROM periodo ORDER BY  periodo_inicio DESC";
		$oConexion= new ConexionClass();
		$rscargo=$oConexion->Ejecutar_Consulta($vConsulta);
		$numeroRegistros=$rscargo->num_rows;
		$tamPag=20; 
    	//pagina actual si no esta definida y limites 
    	if(!isset($pagina))
		{	
			$pagina=1; 
       		$inicio=1; 
       		$final=$tamPag;
		}
		else
		{ 
       		$pagina = $pagina; 
    	} 
    	//calculo del limite inferior 
    	$limitInf=($pagina-1)*$tamPag; 

    	//calculo del numero de paginas 
    	$numPags=ceil($numeroRegistros/$tamPag); 
    	if(!isset($pagina)){ 
       		$pagina=1; 
       		$inicio=1; 
       		$final=$tamPag; 
    	}else{ 
       		$seccionActual=intval(($pagina-1)/$tamPag); 
       		$inicio=($seccionActual*$tamPag)+1; 
       		if($pagina<$numPags) 
       		{ 
          		$final=$inicio+$tamPag-1; 
       		}
			else
			{ 
          		$final=$numPags; 
       		} 
       		if ($final>$numPags)
			{ 
          		$final=$numPags; 
       		} 
		}
		$vConsulta.=" limit ".$limitInf.",".$tamPag;
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);
		return $rs;
	}
	
	function contarPeriodo()
	{
			$vConsulta="SELECT 	periodo_id, periodo_inicio, periodo_fin, periodo_activo FROM periodo ORDER BY  periodo_inicio DESC";
		$oConexion= new ConexionClass();
		$rsarc=$oConexion->Ejecutar_Consulta($vConsulta);
		$nr=$rsarc->num_rows;
		return $nr;
	}
	
	function insertarPeriodo()
	{
		$oConexion= new ConexionClass(); 
		$strSQL="INSERT INTO periodo (periodo_inicio, periodo_fin, periodo_activo) VALUES ('".$oConexion->Escapar_Caracteres($this->PeriodoInicio)."', '".$oConexion->Escapar_Caracteres($this->PeriodoFin)."', '".$oConexion->Escapar_Caracteres($this->PeriodoActivo)."')";
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function actualizarPeriodo()
	{
		$oConexion= new ConexionClass();
		$strSQL="UPDATE periodo SET periodo_inicio = '".$oConexion->Escapar_Caracteres($this->PeriodoInicio)."', periodo_fin = '".$oConexion->Escapar_Caracteres($this->PeriodoFin)."', periodo_activo = '".$oConexion->Escapar_Caracteres($this->PeriodoActivo)."'	WHERE	periodo_id = ".intval($this->PeriodoID);
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function eliminarPeriodo($PeriodoID)	
	{
		$strSQL="DELETE FROM periodo WHERE periodo_id=".intval($PeriodoID);
		$oConexion= new ConexionClass();
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function getPeriodo($PeriodoID)
	{
		$vConsulta="SELECT periodo_id, periodo_inicio, periodo_fin, periodo_activo, concat(periodo_inicio,' - ',periodo_fin) FROM periodo WHERE periodo_id=".intval($PeriodoID);
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;				
	}	
		function getPeriodoActual()
	{
		$vConsulta="SELECT periodo_id, concat(periodo_inicio,' - ',periodo_fin) FROM periodo WHERE periodo_activo=1";
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;
	}
}
?>