<?php
class TipoFuncionarioClass{
	public $tipoFuncionarioID;
	public $TipoFuncionarioNombre;
	public $TipoFuncionarioTipo;
	public $tipoFuncionarioActivo;
	
	function listarTipoFuncionarioTodos($nombreTipoFuncionario,$pagina)
	{
		if(trim($nombreTipoFuncionario)!="")
		{
			$vConsulta="SELECT tipo_funcionario_id, nombre, tipo, activo FROM tipo_funcionario WHERE nombre LIKE '%".$nombreTipoFuncionario."%' ORDER BY nombre";
		}
		else
		{
			$vConsulta="SELECT tipo_funcionario_id, nombre, tipo, activo FROM tipo_funcionario ORDER BY nombre";
		}
		$oConexion= new ConexionClass();
		$rscargo=$oConexion->Ejecutar_Consulta($vConsulta);
		$numeroRegistros=$rscargo->num_rows;
		$tamPag=20; 
    	//pagina actual si no esta definida y limites 
    	if(!isset($pagina))
		{	
			$pagina=1; 
       		$inicio=1; 
       		$final=$tamPag;
		}
		else
		{ 
       		$pagina = $pagina; 
    	} 
    	//calculo del limite inferior 
    	$limitInf=($pagina-1)*$tamPag; 

    	//calculo del numero de paginas 
    	$numPags=ceil($numeroRegistros/$tamPag); 
    	if(!isset($pagina)){ 
       		$pagina=1; 
       		$inicio=1; 
       		$final=$tamPag; 
    	}else{ 
       		$seccionActual=intval(($pagina-1)/$tamPag); 
       		$inicio=($seccionActual*$tamPag)+1; 
       		if($pagina<$numPags) 
       		{ 
          		$final=$inicio+$tamPag-1; 
       		}
			else
			{ 
          		$final=$numPags; 
       		} 
       		if ($final>$numPags)
			{ 
          		$final=$numPags; 
       		} 
		}
		$vConsulta.=" limit ".$limitInf.",".$tamPag;
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);
		return $rs;
	}
	
	function contarTipoFuncionario($nombreTipoFuncionario)
	{
		if(trim($nombreTipoFuncionario)!="")
		{
			$vConsulta="SELECT tipo_funcionario_id, nombre, tipo, activo FROM tipo_funcionario WHERE nombre LIKE '%".$nombreTipoFuncionario."%' ORDER BY nombre";
		}
		else
		{
			$vConsulta="SELECT tipo_funcionario_id, nombre, tipo, activo FROM tipo_funcionario ORDER BY nombre";
		}
		$oConexion= new ConexionClass();
		$rsarc=$oConexion->Ejecutar_Consulta($vConsulta);
		$nr=$rsarc->num_rows;
		return $nr;
	}
	
	function insertaTipoFuncionario()
	{
		$oConexion= new ConexionClass(); 
		$strSQL="INSERT INTO tipo_funcionario (nombre, tipo, activo) VALUES('".$oConexion->Escapar_Caracteres($this->TipoFuncionarioNombre)."', '".$oConexion->Escapar_Caracteres($this->TipoFuncionarioTipo)."', '".$oConexion->Escapar_Caracteres($this->tipoFuncionarioActivo)."')";
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function actualizarTipoFuncionario()
	{
		$oConexion= new ConexionClass();
		$strSQL="UPDATE tipo_funcionario SET nombre = '".$oConexion->Escapar_Caracteres($this->TipoFuncionarioNombre)."', tipo = '".$oConexion->Escapar_Caracteres($this->TipoFuncionarioTipo)."', activo = '".$oConexion->Escapar_Caracteres($this->tipoFuncionarioActivo)."' WHERE tipo_funcionario_id=".intval($this->tipoFuncionarioID);
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function eliminarTipoFuncionario($tipoFuncionarioID)	
	{
		$strSQL="DELETE FROM tipo_funcionario WHERE tipo_funcionario_id=".intval($tipoFuncionarioID);
		$oConexion= new ConexionClass();
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function getTipoFuncionario($tipoFuncionarioID)
	{
		$vConsulta="SELECT tipo_funcionario_id, nombre, tipo, activo FROM tipo_funcionario WHERE tipo_funcionario_id=".intval($tipoFuncionarioID);
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;	
			
	}	
		function getListTipoFuncionariosActivos($tipo)
	{
		$vConsulta="SELECT tipo_funcionario_id, nombre, tipo, activo 
		FROM tipo_funcionario WHERE activo=1 AND tipo LIKE '%".$tipo."%'";
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		return $rs;			
	}
}
?>