<?php
class UsuarioClass{
	public $usuarioID;
	public $usuarioNombre;
	public $usuarioApellidos;
	public $usuarioLogin;
	public $usuarioClave;
	public $usuarioActivo;
	
	function listarUsuarioTodos($nombreUsuario,$pagina)
	{
		$vConsulta="SELECT usu_id, usu_nombre, usu_apellidos, usu_login, usu_clave, usu_activo	
		FROM usuario WHERE usu_id!=1 AND 
		CONCAT(usu_nombre,' ',usu_apellidos) 
		LIKE '%".$nombreUsuario."%' ORDER BY usu_nombre";		
		$oConexion= new ConexionClass();
		$rscargo=$oConexion->Ejecutar_Consulta($vConsulta);
		$numeroRegistros=$rscargo->num_rows;
		$tamPag=20; 
    	//pagina actual si no esta definida y limites 
    	if(!isset($pagina))
		{	
			$pagina=1; 
       		$inicio=1; 
       		$final=$tamPag;
		}
		else
		{ 
       		$pagina = $pagina; 
    	} 
    	//calculo del limite inferior 
    	$limitInf=($pagina-1)*$tamPag; 

    	//calculo del numero de paginas 
    	$numPags=ceil($numeroRegistros/$tamPag); 
    	if(!isset($pagina)){ 
       		$pagina=1; 
       		$inicio=1; 
       		$final=$tamPag; 
    	}else{ 
       		$seccionActual=intval(($pagina-1)/$tamPag); 
       		$inicio=($seccionActual*$tamPag)+1; 
       		if($pagina<$numPags) 
       		{ 
          		$final=$inicio+$tamPag-1; 
       		}
			else
			{ 
          		$final=$numPags; 
       		} 
       		if ($final>$numPags)
			{ 
          		$final=$numPags; 
       		} 
		}
		$vConsulta.=" limit ".$limitInf.",".$tamPag;
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);
		return $rs;
	}
	
	function contarUsuarios($nombreUsuario)
	{
		$vConsulta="SELECT usu_id, usu_nombre, usu_apellidos, usu_login, usu_clave, usu_activo	
		FROM usuario WHERE usu_id!=1 AND 
		CONCAT(usu_nombre,' ',usu_apellidos) LIKE '%".$nombreUsuario."%' ORDER BY usu_nombre";		
		$oConexion= new ConexionClass();
		$rsarc=$oConexion->Ejecutar_Consulta($vConsulta);
		$nr=$rsarc->num_rows;
		return $nr;
	}
	
	function getUsuarioCountNew($nombre)
	{
		$vConsulta="SELECT COUNT(usu_id) AS cant FROM usuario 
		WHERE usu_login='".$nombre."' ";
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;	
	}
	
	function insertarUsuarios()
	{
		$oConexion= new ConexionClass(); 
		$strSQL="INSERT INTO usuario (usu_nombre, usu_apellidos, usu_login, usu_clave, usu_activo)	VALUES ('".$oConexion->Escapar_Caracteres($this->usuarioNombre)."', '".$oConexion->Escapar_Caracteres($this->usuarioApellidos)."', '".$oConexion->Escapar_Caracteres($this->usuarioLogin)."', '".$oConexion->Escapar_Caracteres($this->usuarioClave)."', '".$oConexion->Escapar_Caracteres($this->usuarioActivo)."')";
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function getUsuarioCountUpdate($nombre, $usuID)
	{
		$vConsulta="SELECT COUNT(usu_id) AS cant FROM usuario 
		WHERE usu_login='".$nombre."' AND usu_id != '".$usuID."' ";
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;	
	}
	
	function actualizarUsuarios()
	{
		$oConexion= new ConexionClass();
		$strSQL="UPDATE usuario SET usu_nombre = '".$oConexion->Escapar_Caracteres($this->usuarioNombre)."', usu_apellidos = '".$oConexion->Escapar_Caracteres($this->usuarioApellidos)."', usu_login = '".$oConexion->Escapar_Caracteres($this->usuarioLogin)."', usu_activo = '".$oConexion->Escapar_Caracteres($this->usuarioActivo)."' WHERE usu_id = ".intval($this->usuarioID);
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function getUsuarioCountAcceso($usuID)
	{
		$vConsulta="SELECT COUNT(usu_id) AS cant FROM acceso 
		WHERE usu_id=".$usuID;
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;	
	}
	
	function eliminarUsuario($usuarioID)	
	{
		$strSQL="DELETE FROM usuario WHERE usu_id=".intval($usuarioID);
		$oConexion= new ConexionClass();
		return $oConexion->Ejecutar_SQL($strSQL);
	}
	
	function getUsuario($usuarioID)
	{
		$vConsulta="SELECT usu_id, usu_nombre, usu_apellidos, usu_login, usu_clave, usu_activo FROM usuario WHERE usu_id=".intval($usuarioID);
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;	
			
	}	
		function getUsuarioActual()
	{
		$vConsulta="SELECT usu_id, usu_nombre, usu_apellidos, usu_login, usu_clave, usu_activo FROM usuario WHERE usu_activo=1";
		$oConexion= new ConexionClass();
		$rs=$oConexion->Ejecutar_Consulta($vConsulta);		
		if ($rs->num_rows>0)		
			return $rs->fetch_array();
		else
			return false;			
	}
	
	function updateClave()
	{
		$oConexion= new ConexionClass(); 
		$strSQL="UPDATE usuario SET usu_clave='".$this->usuarioClave."'
		WHERE usu_id=".intval($this->usuarioID);
		return $oConexion->Ejecutar_SQL($strSQL);
	}
}
?>